/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.binary.values;

import java.io.Serializable;
import lombok.Generated;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.PrimitiveConverter;

public final class BinaryValuesByte
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final BinaryValuesByte DEFAULT = new BinaryValuesByte(0, -1);
    private final byte off;
    private final byte on;

    public BinaryValuesByte(int off, int on) {
        this((byte)off, (byte)on);
    }

    public static BinaryValuesByte getDefault() {
        return DEFAULT;
    }

    public boolean isOn(byte value) {
        return value == this.on;
    }

    public boolean isOff(byte value) {
        return !this.isOn(value);
    }

    public BinaryValuesByte invert() {
        return new BinaryValuesByte(this.off, this.on);
    }

    public BinaryValuesInt asInt() {
        return new BinaryValuesInt(PrimitiveConverter.unsignedByteToInt(this.off), PrimitiveConverter.unsignedByteToInt(this.on));
    }

    @Generated
    public BinaryValuesByte(byte off, byte on) {
        this.off = off;
        this.on = on;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryValuesByte)) {
            return false;
        }
        BinaryValuesByte other = (BinaryValuesByte)o;
        if (this.getOff() != other.getOff()) {
            return false;
        }
        return this.getOn() == other.getOn();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOff();
        result = result * 59 + this.getOn();
        return result;
    }

    @Generated
    public byte getOff() {
        return this.off;
    }

    @Generated
    public byte getOn() {
        return this.on;
    }
}

