/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.binary.connected;

import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.connected.ConnectedComponentUnionFind;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.object.ObjectCollection;

public class ObjectsFromConnectedComponentsFactory {
    private final ConnectedComponentUnionFind unionFind;

    public ObjectsFromConnectedComponentsFactory() {
        this(false);
    }

    public ObjectsFromConnectedComponentsFactory(boolean bigNeighborhood) {
        this(bigNeighborhood, 1);
    }

    public ObjectsFromConnectedComponentsFactory(int minNumberVoxels) {
        this(false, minNumberVoxels);
    }

    public ObjectsFromConnectedComponentsFactory(boolean bigNeighborhood, int minNumberVoxels) {
        this.unionFind = new ConnectedComponentUnionFind(minNumberVoxels, bigNeighborhood);
    }

    public ObjectCollection createUnsignedByte(BinaryVoxels<UnsignedByteBuffer> voxels) {
        return this.unionFind.deriveConnectedByte(voxels);
    }

    public ObjectCollection createUnsignedInt(BinaryVoxels<UnsignedIntBuffer> voxels) {
        return this.unionFind.deriveConnectedInt(voxels);
    }
}

