/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.binary.connected;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.SlidingBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.IterateVoxelsNeighbors;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighbor;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborAbsoluteWithSlidingBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborFactory;
import org.anchoranalysis.image.voxel.neighborhood.Neighborhood;
import org.anchoranalysis.image.voxel.neighborhood.NeighborhoodFactory;
import org.anchoranalysis.spatial.point.Point3i;
import org.jgrapht.alg.util.UnionFind;

final class MergeWithNeighbors {
    private final boolean do3D;
    private final ProcessVoxelNeighbor<Integer> process;
    private final Neighborhood neighborhood;
    private final SlidingBuffer<UnsignedIntBuffer> slidingIndex;
    private final UnionFind<Integer> unionIndex;

    public MergeWithNeighbors(Voxels<UnsignedIntBuffer> voxels, UnionFind<Integer> unionIndex, boolean do3D, boolean bigNeighborhood) {
        this.do3D = do3D;
        this.slidingIndex = new SlidingBuffer<UnsignedIntBuffer>(voxels);
        this.unionIndex = unionIndex;
        this.neighborhood = NeighborhoodFactory.of(bigNeighborhood);
        this.process = ProcessVoxelNeighborFactory.withinExtent(new PointEvaluator(this.slidingIndex, unionIndex));
    }

    public int minNeighborLabel(Point3i point, int existingValue, int indexBuffer) {
        return IterateVoxelsNeighbors.callEachPointInNeighborhood(point, this.neighborhood, this.do3D, this.process, existingValue, indexBuffer);
    }

    public void shift() {
        this.slidingIndex.shift();
    }

    public void addElement(Integer element) {
        this.unionIndex.addElement((Object)element);
    }

    private static class PointEvaluator
    extends ProcessVoxelNeighborAbsoluteWithSlidingBuffer<Integer> {
        private int minLabel;
        private final UnionFind<Integer> unionIndex;

        public PointEvaluator(SlidingBuffer<UnsignedIntBuffer> slidingIndex, UnionFind<Integer> unionIndex) {
            super(slidingIndex);
            this.unionIndex = unionIndex;
        }

        @Override
        public void initSource(int sourceValue, int sourceOffsetXY) {
            super.initSource(sourceValue, sourceOffsetXY);
            this.minLabel = -1;
        }

        @Override
        public void processPoint(int xChange, int yChange, int x1, int y1) {
            int indexVal = this.getInt(xChange, yChange);
            if (indexVal == 0) {
                return;
            }
            if (this.minLabel == -1) {
                this.minLabel = indexVal;
            } else if (indexVal != this.minLabel) {
                this.unionIndex.union((Object)this.minLabel, (Object)indexVal);
                if (indexVal < this.minLabel) {
                    this.minLabel = indexVal;
                }
            }
        }

        @Override
        public Integer collectResult() {
            assert (this.minLabel != 0);
            return this.minLabel;
        }
    }
}

