/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.binary;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;

class BinaryVoxelsByte
extends BinaryVoxels<UnsignedByteBuffer> {
    private BinaryValuesByte binaryValuesByte = this.binaryValues().asByte();

    public BinaryVoxelsByte(Voxels<UnsignedByteBuffer> voxels, BinaryValuesInt binaryValuesByte) {
        super(voxels, binaryValuesByte);
    }

    @Override
    public boolean isOn(int x, int y, int z) {
        int offset = this.voxels().extent().offset(x, y);
        return ((UnsignedByteBuffer)this.voxels().sliceBuffer(z)).getRaw(offset) != this.binaryValuesByte.getOff();
    }

    @Override
    public boolean isOff(int x, int y, int z) {
        return !this.isOn(x, y, z);
    }

    @Override
    public void setOn(int x, int y, int z) {
        int offset = this.voxels().extent().offset(x, y);
        ((UnsignedByteBuffer)this.voxels().sliceBuffer(z)).putRaw(offset, this.binaryValuesByte.getOn());
    }

    @Override
    public void setOff(int x, int y, int z) {
        int offset = this.voxels().extent().offset(x, y);
        ((UnsignedByteBuffer)this.voxels().sliceBuffer(z)).putRaw(offset, this.binaryValuesByte.getOff());
    }

    public BinaryValuesByte asByte() {
        return this.binaryValuesByte;
    }

    public BinaryVoxelsByte duplicate() {
        return new BinaryVoxelsByte(this.voxels().duplicate(), this.binaryValues());
    }

    @Override
    protected BinaryVoxels<UnsignedByteBuffer> binaryVoxelsFor(Voxels<UnsignedByteBuffer> voxels, BinaryValuesInt binaryValues) {
        return new BinaryVoxelsByte(voxels, binaryValues);
    }
}

