/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.binary;

import lombok.Generated;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssigner;
import org.anchoranalysis.image.voxel.binary.BinaryOnOffSetter;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracter;
import org.anchoranalysis.spatial.box.Extent;

public abstract class BinaryVoxels<T>
implements BinaryOnOffSetter {
    private final Voxels<T> voxels;
    private BinaryValuesInt binaryValues;

    public void invert() {
        this.binaryValues = this.binaryValues.createInverted();
    }

    public Extent extent() {
        return this.voxels.extent();
    }

    public boolean hasOnVoxel() {
        return this.voxels.extract().voxelsEqualTo(this.binaryValues.getOn()).anyExists();
    }

    public boolean hasOffVoxel() {
        return this.voxels.extract().voxelsEqualTo(this.binaryValues.getOff()).anyExists();
    }

    public abstract BinaryVoxels<T> duplicate();

    public T sliceBuffer(int z) {
        return this.voxels.sliceBuffer(z);
    }

    public VoxelBuffer<T> slice(int z) {
        return this.voxels.slice(z);
    }

    public BinaryVoxels<T> sliceBinary(int z) {
        return this.binaryVoxelsFor(this.extract().slice(z), this.binaryValues());
    }

    protected abstract BinaryVoxels<T> binaryVoxelsFor(Voxels<T> var1, BinaryValuesInt var2);

    public VoxelsAssigner assignOn() {
        return this.voxels.assignValue(this.binaryValues.getOn());
    }

    public VoxelsAssigner assignOff() {
        return this.voxels.assignValue(this.binaryValues.getOff());
    }

    public int countOn() {
        return this.voxels.extract().voxelsEqualTo(this.binaryValues.getOn()).count();
    }

    public int countOff() {
        return this.voxels.extract().voxelsEqualTo(this.binaryValues.getOff()).count();
    }

    public VoxelsExtracter<T> extract() {
        return this.voxels.extract();
    }

    public SliceBufferIndex<T> slices() {
        return this.voxels.slices();
    }

    public String toString() {
        return this.voxels.toString();
    }

    @Generated
    public BinaryVoxels(Voxels<T> voxels, BinaryValuesInt binaryValues) {
        this.voxels = voxels;
        this.binaryValues = binaryValues;
    }

    @Generated
    public Voxels<T> voxels() {
        return this.voxels;
    }

    @Generated
    public BinaryValuesInt binaryValues() {
        return this.binaryValues;
    }
}

