/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.assigner;

import java.util.Optional;
import java.util.function.IntPredicate;
import lombok.Generated;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssigner;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsObjectMask;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

abstract class Base<T>
implements VoxelsAssigner {
    private final Voxels<T> voxels;
    protected final int valueToAssign;

    @Override
    public void toAll() {
        this.voxels.extent().iterateOverZ(z -> this.assignToEntireBuffer(this.voxels.sliceBuffer(z)));
    }

    @Override
    public void toBox(BoundingBox box) {
        ReadableTuple3i cornerMin = box.cornerMin();
        ReadableTuple3i cornerMax = box.calculateCornerMaxInclusive();
        Extent extent = this.voxels.extent();
        for (int z = cornerMin.z(); z <= cornerMax.z(); ++z) {
            T buffer = this.voxels.sliceBuffer(z);
            for (int y = cornerMin.y(); y <= cornerMax.y(); ++y) {
                for (int x = cornerMin.x(); x <= cornerMax.x(); ++x) {
                    int offset = extent.offset(x, y);
                    this.assignAtBufferPosition(buffer, offset);
                }
            }
        }
    }

    @Override
    public void toVoxel(int x, int y, int z) {
        T buffer = this.voxels.sliceBuffer(z);
        this.assignAtBufferPosition(buffer, this.voxels.extent().offset(x, y));
    }

    protected abstract void assignToEntireBuffer(T var1);

    protected abstract void assignAtBufferPosition(T var1, int var2);

    @Override
    public void toObject(ObjectMask object) {
        this.toObject(object, Optional.empty());
    }

    @Override
    public void toObjectIf(ObjectMask object, IntPredicate voxelPredicate) {
        IterateVoxelsObjectMask.withVoxelBuffer(object, this.voxels, (buffer, offset) -> {
            int existingValue = buffer.getInt(offset);
            if (voxelPredicate.test(existingValue)) {
                this.assignToBuffer(buffer, offset);
            }
        });
    }

    @Override
    public boolean toObjectWhile(ObjectMask object, IntPredicate voxelPredicate) {
        if (IterateVoxelsObjectMask.allMatchIntensity(object, this.voxels, voxelPredicate)) {
            this.toObject(object, Optional.empty());
            return true;
        }
        return false;
    }

    @Override
    public void toObject(ObjectMask object, BoundingBox restrictTo) {
        this.toObject(object, Optional.of(restrictTo));
    }

    @Override
    public void toEitherTwoObjects(ObjectMask object1, ObjectMask object2, BoundingBox restrictTo) {
        this.toObject(object1, restrictTo);
        this.toObject(object2, restrictTo);
    }

    private void toObject(ObjectMask object, Optional<BoundingBox> restrictTo) {
        IterateVoxelsObjectMask.withVoxelBuffer(object, this.voxels, restrictTo, this::assignToBuffer);
    }

    private void assignToBuffer(VoxelBuffer<T> buffer, int offset) {
        buffer.putInt(offset, this.valueToAssign);
    }

    @Generated
    public Base(Voxels<T> voxels, int valueToAssign) {
        this.voxels = voxels;
        this.valueToAssign = valueToAssign;
    }
}

