/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.arithmetic;

import java.util.function.IntFunction;
import org.anchoranalysis.image.voxel.arithmetic.Base;
import org.anchoranalysis.image.voxel.arithmetic.BinaryOperationHelper;
import org.anchoranalysis.image.voxel.arithmetic.UnsignedIntHelper;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.spatial.box.Extent;

class UnsignedIntImplementation
extends Base<UnsignedIntBuffer> {
    public UnsignedIntImplementation(Extent extent, IntFunction<UnsignedIntBuffer> bufferForSlice) {
        super(extent, bufferForSlice);
    }

    @Override
    protected void multiplyBuffer(UnsignedIntBuffer buffer, double factor) {
        UnsignedIntHelper.calculateForEveryVoxel(buffer, value -> BinaryOperationHelper.multiplyByLong(value, factor));
    }

    @Override
    protected void subtractFromBuffer(UnsignedIntBuffer buffer, int valueToSubtractFrom) {
        UnsignedIntHelper.calculateForEveryVoxel(buffer, value -> (long)valueToSubtractFrom - value);
    }

    @Override
    protected void addToBufferIndex(UnsignedIntBuffer buffer, int index, int valueToBeAdded) {
        UnsignedIntHelper.calculateForEveryVoxel(buffer, value -> value + (long)valueToBeAdded);
    }

    @Override
    protected void multiplyByBufferIndex(UnsignedIntBuffer buffer, int index, double factor) {
        UnsignedIntHelper.calculateForIndex(buffer, index, value -> BinaryOperationHelper.multiplyByLong(value, factor));
    }

    @Override
    protected void divideByBuffer(UnsignedIntBuffer buffer, int divisor) {
        UnsignedIntHelper.calculateForEveryVoxel(buffer, value -> value / (long)divisor);
    }
}

