/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.arithmetic;

import java.nio.FloatBuffer;
import java.util.function.IntFunction;
import org.anchoranalysis.image.voxel.arithmetic.Base;
import org.anchoranalysis.image.voxel.arithmetic.BinaryOperationHelper;
import org.anchoranalysis.image.voxel.arithmetic.FloatHelper;
import org.anchoranalysis.spatial.box.Extent;

class FloatImplementation
extends Base<FloatBuffer> {
    public FloatImplementation(Extent extent, IntFunction<FloatBuffer> bufferForSlice) {
        super(extent, bufferForSlice);
    }

    @Override
    protected void multiplyBuffer(FloatBuffer buffer, double factor) {
        FloatHelper.calculateForEveryVoxel(buffer, value -> BinaryOperationHelper.multiplyByFloat(value, factor));
    }

    @Override
    protected void subtractFromBuffer(FloatBuffer buffer, int valueToSubtractFrom) {
        FloatHelper.calculateForEveryVoxel(buffer, value -> (float)valueToSubtractFrom - value);
    }

    @Override
    protected void addToBufferIndex(FloatBuffer buffer, int index, int valueToBeAdded) {
        FloatHelper.calculateForEveryVoxel(buffer, value -> value + (float)valueToBeAdded);
    }

    @Override
    protected void multiplyByBufferIndex(FloatBuffer buffer, int index, double factor) {
        FloatHelper.calculateForIndex(buffer, index, value -> BinaryOperationHelper.multiplyByFloat(value, factor));
    }

    @Override
    protected void divideByBuffer(FloatBuffer buffer, int divisor) {
        FloatHelper.calculateForEveryVoxel(buffer, value -> value / (float)divisor);
    }
}

