/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.arithmetic.VoxelsArithmetic;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssigner;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.IncorrectVoxelTypeException;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedIntVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracter;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

public class VoxelsUntyped {
    private Voxels<?> voxels;

    public VoxelsUntyped(Voxels<?> voxels) {
        this.voxels = voxels;
    }

    public Voxels<?> any() {
        return this.voxels;
    }

    public Voxels<?> checkIdenticalDataType(VoxelDataType match) {
        if (match.equals(this.voxels.dataType())) {
            return this.voxels;
        }
        throw new IncorrectVoxelTypeException(String.format("Incompatible data-type %s has been requested from voxels with data-type %s", match, this.voxels.dataType()));
    }

    public Voxels<UnsignedByteBuffer> asByte() {
        if (!this.voxels.dataType().equals(UnsignedByteVoxelType.INSTANCE)) {
            throw new IncorrectVoxelTypeException("Voxels do not contain unsigned 8-bit data (byte)");
        }
        return this.voxels;
    }

    public Voxels<UnsignedShortBuffer> asShort() {
        if (!this.voxels.dataType().equals(UnsignedShortVoxelType.INSTANCE)) {
            throw new IncorrectVoxelTypeException("Voxels do not contain unsigned 16-bit data (int)");
        }
        return this.voxels;
    }

    public Voxels<UnsignedIntBuffer> asInt() {
        if (!this.voxels.dataType().equals(UnsignedIntVoxelType.INSTANCE)) {
            throw new IncorrectVoxelTypeException("Voxels do not contain unsigned 32-bit data (int)");
        }
        return this.voxels;
    }

    public Voxels<FloatBuffer> asFloat() {
        if (!this.voxels.dataType().equals(FloatVoxelType.INSTANCE)) {
            throw new IncorrectVoxelTypeException("Voxels do not contain float data");
        }
        return this.voxels;
    }

    public VoxelDataType getVoxelDataType() {
        return this.voxels.dataType();
    }

    public void copyVoxelsTo(BoundingBox boxSource, VoxelsUntyped destination, BoundingBox boxDestination) {
        this.voxels.extract().boxCopyTo(boxSource, this.destinationVoxelsChecked(destination), boxDestination);
    }

    public void copyVoxelsTo(ObjectMask objectSource, VoxelsUntyped destination, BoundingBox boxDestination) {
        this.voxels.extract().objectCopyTo(objectSource, this.destinationVoxelsChecked(destination), boxDestination);
    }

    public void subtractFromMaxValue() {
        int maxValue = (int)this.getVoxelDataType().maxValue();
        this.voxels.arithmetic().subtractFrom(maxValue);
    }

    public void replaceSlice(int sliceIndexToUpdate, VoxelsUntyped sourceVoxels, int sliceIndexSource, boolean duplicate) {
        VoxelsUntyped.checkMatchingDataTypes(sourceVoxels.getVoxelDataType(), this.getVoxelDataType());
        this.voxels.replaceSlice(sliceIndexToUpdate, VoxelsUntyped.sourceSlice(sourceVoxels.any(), sliceIndexSource, duplicate));
    }

    public <T> VoxelBuffer<T> slice(int z) {
        return this.voxels.slice(z);
    }

    public Extent extent() {
        return this.voxels.extent();
    }

    public VoxelsArithmetic arithmetic() {
        return this.voxels.arithmetic();
    }

    public VoxelsAssigner assignValue(int valueToAssign) {
        return this.voxels.assignValue(valueToAssign);
    }

    public VoxelsExtracter<?> extract() {
        return this.voxels.extract();
    }

    private Voxels destinationVoxelsChecked(VoxelsUntyped destination) {
        VoxelsUntyped.checkMatchingDataTypes(this.getVoxelDataType(), destination.getVoxelDataType());
        return destination.checkIdenticalDataType(this.voxels.dataType());
    }

    private static void checkMatchingDataTypes(VoxelDataType source, VoxelDataType destination) {
        if (!destination.equals(source)) {
            throw new IncorrectVoxelTypeException(String.format("Voxel data-types do not match in source (%s) and destination (%s).", source, destination));
        }
    }

    private static <T> VoxelBuffer<T> sourceSlice(Voxels<T> sourceVoxels, int sliceIndex, boolean duplicate) {
        VoxelBuffer<T> slice = sourceVoxels.slice(sliceIndex);
        if (duplicate) {
            return slice;
        }
        return slice.duplicate();
    }
}

