/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.time;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

public class TimeSeries
implements Iterable<Stack> {
    private final List<Stack> list;

    public TimeSeries(Stack frame) {
        this.list = Arrays.asList(frame);
    }

    public TimeSeries(Stream<Stack> frames) {
        this.list = frames.collect(Collectors.toList());
    }

    public Stack getFrame(int index) {
        return this.list.get(index);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public boolean allChannelsHaveType(VoxelDataType voxelDataType) {
        return this.list.stream().allMatch(stack -> stack.allChannelsHaveType(voxelDataType));
    }

    @Override
    public Iterator<Stack> iterator() {
        return this.list.iterator();
    }
}

