/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.time;

import java.util.Optional;
import java.util.Set;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.identifier.provider.store.StoreSupplier;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.time.TimeSeries;

public class ExtractFrameStore
implements NamedProviderStore<TimeSeries> {
    private final NamedProviderStore<Stack> stacks;
    private final int timeIndex;

    public ExtractFrameStore(NamedProviderStore<Stack> stacks) {
        this(stacks, 0);
    }

    public ExtractFrameStore(NamedProviderStore<Stack> stacks, int timeIndex) {
        this.stacks = stacks;
        this.timeIndex = timeIndex;
    }

    public Optional<TimeSeries> getOptional(String key) throws NamedProviderGetException {
        return this.stacks.getOptional(key).map(TimeSeries::new);
    }

    public Set<String> keys() {
        return this.stacks.keys();
    }

    public void add(String identifier, StoreSupplier<TimeSeries> supplier) throws OperationFailedException {
        this.stacks.add(identifier, () -> ((TimeSeries)supplier.get()).getFrame(this.timeIndex));
    }
}

