/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.output.generator;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.writer.StackWriter;
import org.anchoranalysis.image.io.stack.output.StackWriteOptions;
import org.anchoranalysis.image.io.stack.output.generator.GeneratorOutputter;
import org.anchoranalysis.image.io.stack.output.generator.RasterGenerator;
import org.anchoranalysis.io.output.bean.OutputWriteSettings;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

public abstract class RasterGeneratorSelectFormat<T>
extends RasterGenerator<T> {
    @Override
    protected String selectFileExtension(Stack stack, StackWriteOptions options, OutputWriteSettings settings, Optional<Logger> logger) throws OperationFailedException {
        try {
            return GeneratorOutputter.fileExtensionWriter(settings, options, logger);
        }
        catch (ImageIOException e) {
            throw new OperationFailedException((Throwable)((Object)e));
        }
    }

    @Override
    protected void writeToFile(T element, Stack transformedElement, StackWriteOptions options, OutputWriteSettings settings, Path filePath) throws OutputWriteFailedException {
        try {
            StackWriter writer = GeneratorOutputter.writer(settings);
            writer.writeStack(transformedElement, filePath, options);
        }
        catch (ImageIOException e) {
            throw new OutputWriteFailedException((Throwable)((Object)e));
        }
    }
}

