/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.output.generator;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributes;
import org.anchoranalysis.image.io.stack.output.generator.RasterGenerator;
import org.anchoranalysis.image.io.stack.output.generator.RasterGeneratorSelectFormat;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

public abstract class RasterGeneratorDelegateToRaster<S, T>
extends RasterGeneratorSelectFormat<T> {
    private final RasterGenerator<S> delegate;

    @Override
    public StackWriteAttributes guaranteedImageAttributes() {
        return this.delegate.guaranteedImageAttributes();
    }

    public Stack transform(T element) throws OutputWriteFailedException {
        try {
            Stack stack = (Stack)this.getDelegate().transform(this.convertBeforeAssign(element));
            return this.convertBeforeTransform(stack);
        }
        catch (OperationFailedException e) {
            throw new OutputWriteFailedException((Throwable)e);
        }
    }

    protected abstract S convertBeforeAssign(T var1) throws OperationFailedException;

    protected abstract Stack convertBeforeTransform(Stack var1);

    protected RasterGenerator<S> getDelegate() {
        return this.delegate;
    }

    protected RasterGeneratorDelegateToRaster(RasterGenerator<S> delegate) {
        this.delegate = delegate;
    }
}

