/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.output.box;

import java.util.Optional;
import javax.annotation.Nullable;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class ScaleableBackground {
    private final DisplayStack stack;
    private final Optional<ScaleFactor> scaleFactor;
    @Nullable
    private final VoxelsResizer resizer;

    public static ScaleableBackground noScaling(DisplayStack stack) {
        return new ScaleableBackground(stack, Optional.empty(), null);
    }

    private ScaleableBackground(DisplayStack stack, Optional<ScaleFactor> scaleFactor, VoxelsResizer resizer) {
        this.stack = stack.projectMax();
        this.scaleFactor = scaleFactor;
        this.resizer = resizer;
    }

    public static ScaleableBackground scaleBy(DisplayStack stack, ScaleFactor scaleFactor, VoxelsResizer resizer) {
        return new ScaleableBackground(stack, Optional.of(scaleFactor), resizer);
    }

    public int getNumberChannels() {
        return this.stack.getNumberChannels();
    }

    public Stack extractRegionFromStack(BoundingBox box) throws OperationFailedException {
        if (this.scaleFactor.isPresent()) {
            return this.extractStackScaled(box, this.scaleFactor.get());
        }
        return this.extractStackUnscaled(box);
    }

    public Extent sizeAfterAnyScaling() {
        Extent extent = this.stack.extent();
        if (this.scaleFactor.isPresent()) {
            return extent.scaleXYBy(this.scaleFactor.get(), true);
        }
        return extent;
    }

    public boolean isRGB() {
        return this.stack.isRGB();
    }

    private Stack extractStackUnscaled(BoundingBox box) throws OperationFailedException {
        return this.stack.getStack().mapChannel(channel -> this.extractChannelUnscaled((Channel)channel, box));
    }

    private Stack extractStackScaled(BoundingBox box, ScaleFactor scaleFactor) throws OperationFailedException {
        BoundingBox boxUnscaled = box.scaleClampTo(scaleFactor.invert(), this.stack.extent());
        return this.stack.getStack().mapChannel(channel -> this.extractChannelScaled((Channel)channel, boxUnscaled, box));
    }

    private Channel extractChannelUnscaled(Channel channel, BoundingBox box) {
        return this.channelFor(ScaleableBackground.extractBoundingBox(channel, box));
    }

    private Channel extractChannelScaled(Channel channel, BoundingBox boxUnscaled, BoundingBox boxScaled) {
        Voxels<?> voxelsUnscaled = ScaleableBackground.extractBoundingBox(channel, boxUnscaled);
        Voxels voxelsScaled = voxelsUnscaled.extract().resizedXY(boxScaled.extent().x(), boxScaled.extent().y(), this.resizer);
        return this.channelFor(voxelsScaled);
    }

    private Channel channelFor(Voxels<?> voxels) {
        return ChannelFactory.instance().create(voxels, this.stack.resolution());
    }

    private static Voxels<?> extractBoundingBox(Channel channel, BoundingBox box) {
        return channel.extract().region(box, false);
    }
}

