/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.output;

import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.StackRGBState;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributes;

public class StackWriteAttributesFactory {
    private static final StackWriteAttributes THREE_CHANNELS_ALWAYS_2D = new StackWriteAttributes(true, false, true, StackRGBState.NOT_RGB, false);
    private static final StackWriteAttributes THREE_CHANNELS_MAYBE_3D = new StackWriteAttributes(false, false, true, StackRGBState.NOT_RGB, false);
    private static final StackWriteAttributes SINGLE_CHANNEL_ALWAYS_2D = new StackWriteAttributes(true, true, false, StackRGBState.NOT_RGB, false);
    private static final StackWriteAttributes SINGLE_CHANNEL_MAYBE_3D = new StackWriteAttributes(false, true, false, StackRGBState.NOT_RGB, false);
    private static final StackWriteAttributes BINARY_CHANNEL_MAYBE_3D = new StackWriteAttributes(false, true, false, StackRGBState.NOT_RGB, true);
    private static final StackWriteAttributes BINARY_CHANNEL_ALWAYS_2D = new StackWriteAttributes(true, true, false, StackRGBState.NOT_RGB, true);

    public static StackWriteAttributes maybeAlways2D(boolean always2D) {
        return new StackWriteAttributes(always2D, false, false, StackRGBState.NOT_RGB, false);
    }

    public static StackWriteAttributes rgbMaybe3D(boolean plusAlpha) {
        return new StackWriteAttributes(false, false, !plusAlpha, StackRGBState.multiplexAlpha(plusAlpha), false);
    }

    public static StackWriteAttributes binaryChannel(boolean always2D) {
        if (always2D) {
            return BINARY_CHANNEL_ALWAYS_2D;
        }
        return BINARY_CHANNEL_MAYBE_3D;
    }

    public static StackWriteAttributes singleChannelMaybe3D(boolean always2D) {
        if (always2D) {
            return SINGLE_CHANNEL_ALWAYS_2D;
        }
        return SINGLE_CHANNEL_MAYBE_3D;
    }

    public static StackWriteAttributes maybeRGB(boolean rgb, boolean always2D, boolean plusAlpha) {
        return new StackWriteAttributes(always2D, false, !plusAlpha, StackRGBState.multiplex(rgb, plusAlpha), false);
    }

    public static StackWriteAttributes maybeRGBWithoutAlpha(boolean rgb) {
        if (rgb) {
            return new StackWriteAttributes(true, false, true, StackRGBState.RGB_WITHOUT_ALPHA, false);
        }
        return new StackWriteAttributes(false, false, false, StackRGBState.NOT_RGB, false);
    }

    public static StackWriteAttributes rgb(boolean always2D, boolean plusAlpha) {
        if (always2D) {
            return new StackWriteAttributes(true, false, !plusAlpha, StackRGBState.multiplexAlpha(plusAlpha), false);
        }
        return StackWriteAttributesFactory.rgbMaybe3D(plusAlpha);
    }

    public static StackWriteAttributes from(Stack stack) {
        StackWriteAttributes attributes = StackWriteAttributesFactory.fromWithoutBitDepthCheck(stack);
        if (StackWriteAttributesFactory.hasAllEightBitChannels(stack)) {
            return attributes.allChannelsEightBit();
        }
        return attributes;
    }

    private static boolean hasAllEightBitChannels(Stack stack) {
        for (Channel channel : stack) {
            if (channel.getVoxelDataType().bitDepth() == 8) continue;
            return false;
        }
        return true;
    }

    private static StackWriteAttributes fromWithoutBitDepthCheck(Stack stack) {
        boolean singleSlice;
        int numberChannels = stack.getNumberChannels();
        boolean bl = singleSlice = !stack.hasMoreThanOneSlice();
        if (numberChannels == 3) {
            if (stack.isRGB()) {
                return StackWriteAttributesFactory.rgb(singleSlice, false);
            }
            return StackWriteAttributesFactory.threeChannels(singleSlice);
        }
        if (numberChannels == 4 && stack.isRGB()) {
            return StackWriteAttributesFactory.rgb(singleSlice, true);
        }
        if (numberChannels == 1) {
            return StackWriteAttributesFactory.singleChannelMaybe3D(singleSlice);
        }
        return new StackWriteAttributes(singleSlice, false, false, StackRGBState.NOT_RGB, false);
    }

    private static StackWriteAttributes threeChannels(boolean always2D) {
        return always2D ? THREE_CHANNELS_ALWAYS_2D : THREE_CHANNELS_MAYBE_3D;
    }

    private StackWriteAttributesFactory() {
    }
}

