/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.output;

import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.value.StringUtilities;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.StackRGBState;

public class StackWriteAttributes {
    private boolean always2D;
    private boolean singleChannel;
    private boolean threeChannels;
    private StackRGBState rgb;
    private boolean binary;
    private boolean eightBitChannels;

    public StackWriteAttributes(boolean always2D, boolean singleChannel, boolean threeChannels, StackRGBState rgb, boolean binary) {
        this(always2D, singleChannel, threeChannels, rgb, binary, false);
    }

    public StackWriteAttributes always2D(boolean binary) {
        return new StackWriteAttributes(true, this.singleChannel, this.threeChannels, this.rgb, binary);
    }

    public StackWriteAttributes rgb(boolean plusAlpha) {
        StackRGBState state = plusAlpha ? StackRGBState.RGB_WITH_ALPHA : StackRGBState.RGB_WITHOUT_ALPHA;
        return new StackWriteAttributes(this.always2D, false, true, state, false);
    }

    public StackWriteAttributes and(StackWriteAttributes other) {
        return new StackWriteAttributes(this.always2D && other.always2D, this.singleChannel && other.singleChannel, this.threeChannels && other.threeChannels, this.rgb.min(other.rgb), this.binary && other.binary, this.eightBitChannels && other.eightBitChannels);
    }

    public StackWriteAttributes or(StackWriteAttributes other) {
        return new StackWriteAttributes(this.always2D || other.always2D, this.singleChannel || other.singleChannel, this.threeChannels || other.threeChannels, this.rgb.max(other.rgb), this.binary || other.binary, this.eightBitChannels || other.eightBitChannels);
    }

    public boolean writeAsRGB(Stack stack) {
        return stack.isRGB() && stack.getNumberChannels() == 3 && this.rgb == StackRGBState.RGB_WITHOUT_ALPHA || stack.getNumberChannels() == 4 && this.rgb == StackRGBState.RGB_WITH_ALPHA;
    }

    public StackWriteAttributes allChannelsEightBit() {
        return new StackWriteAttributes(this.always2D, this.singleChannel, this.threeChannels, this.rgb, this.binary, true);
    }

    public String toString() {
        return (String)StringUtilities.joinNonEmpty((String)" ", (String[])new String[]{this.describeZDimension(), this.describeChannels()}).orElseThrow(AnchorImpossibleSituationException::new);
    }

    private String describeZDimension() {
        if (this.always2D) {
            return "2D";
        }
        return "possibly-3D";
    }

    private String describeChannels() {
        if (this.binary) {
            return "binary";
        }
        if (this.singleChannel) {
            return "grayscale";
        }
        if (this.rgb == StackRGBState.RGB_WITHOUT_ALPHA) {
            return "rgb";
        }
        if (this.rgb == StackRGBState.RGB_WITH_ALPHA) {
            return "rgba";
        }
        if (this.threeChannels) {
            return "three-channel";
        }
        return "";
    }

    StackWriteAttributes(boolean always2D, boolean singleChannel, boolean threeChannels, StackRGBState rgb, boolean binary, boolean eightBitChannels) {
        this.always2D = always2D;
        this.singleChannel = singleChannel;
        this.threeChannels = threeChannels;
        this.rgb = rgb;
        this.binary = binary;
        this.eightBitChannels = eightBitChannels;
    }

    public boolean isAlways2D() {
        return this.always2D;
    }

    public boolean isSingleChannel() {
        return this.singleChannel;
    }

    public boolean isThreeChannels() {
        return this.threeChannels;
    }

    public StackRGBState getRgb() {
        return this.rgb;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isEightBitChannels() {
        return this.eightBitChannels;
    }
}

