/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.input;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.core.stack.named.NamedStacks;
import org.anchoranalysis.image.io.stack.time.ExtractFrameStore;
import org.anchoranalysis.image.io.stack.time.TimeSeries;
import org.anchoranalysis.io.input.InputFromManager;

public interface ProvidesStackInput
extends InputFromManager {
    default public Stack asStack(Logger logger) throws OperationFailedException {
        NamedStacks set = this.asSet(logger);
        if (set.isEmpty()) {
            throw new OperationFailedException("No stack exists in the input. Exactly one is required.");
        }
        if (set.size() > 1) {
            throw new OperationFailedException("More than one stack exists in the input, only one is expected.");
        }
        return (Stack)set.getArbitraryElement();
    }

    default public NamedStacks asSet(Logger logger) throws OperationFailedException {
        NamedStacks set = new NamedStacks();
        this.addToStoreInferNames(new ExtractFrameStore((NamedProviderStore<Stack>)set), 0, logger);
        return set;
    }

    default public void addToStoreInferNames(NamedProviderStore<Stack> store, Logger logger) throws OperationFailedException {
        this.addToStoreInferNames(new ExtractFrameStore(store), 0, logger);
    }

    public int numberFrames() throws OperationFailedException;

    public void addToStoreInferNames(NamedProviderStore<TimeSeries> var1, int var2, Logger var3) throws OperationFailedException;

    public void addToStoreWithName(String var1, NamedProviderStore<TimeSeries> var2, int var3, Logger var4) throws OperationFailedException;
}

