/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.input;

import java.nio.file.Path;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;

public class MaskReader {
    public static Mask openMask(StackReader stackReader, Path path, BinaryValuesInt binaryValues, OperationContext context) throws ImageIOException {
        Stack stack = stackReader.readStack(path, context);
        if (stack.getNumberChannels() != 1) {
            throw new ImageIOException(String.format("There must be exactly one channel, but there are %d", stack.getNumberChannels()));
        }
        return new Mask(stack.getChannel(0), binaryValues);
    }

    private MaskReader() {
    }
}

