/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.object.output.rgb;

import io.vavr.control.Either;
import org.anchoranalysis.bean.shared.color.scheme.HSB;
import org.anchoranalysis.core.color.ColorIndex;
import org.anchoranalysis.core.color.ColorIndexModulo;
import org.anchoranalysis.core.color.ColorList;
import org.anchoranalysis.core.color.RGBColor;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.object.properties.ObjectCollectionWithProperties;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.io.bean.object.draw.Outline;
import org.anchoranalysis.image.io.object.output.rgb.ObjectsAsRGBGenerator;
import org.anchoranalysis.image.io.stack.ConvertStackToRGB;
import org.anchoranalysis.overlay.bean.DrawObject;
import org.anchoranalysis.overlay.writer.ObjectDrawAttributes;

public class DrawObjectsGenerator
extends ObjectsAsRGBGenerator {
    private DrawObjectsGenerator(DrawObject drawObject, Either<Dimensions, DisplayStack> background, ColorIndex colorIndex) {
        super(drawObject, new ObjectDrawAttributes(colorIndex), background);
    }

    public static DrawObjectsGenerator withBackgroundAndColors(DrawObject drawObject, DisplayStack background, ColorIndex colorIndex) {
        return new DrawObjectsGenerator(drawObject, (Either<Dimensions, DisplayStack>)Either.right((Object)background), colorIndex);
    }

    public static DrawObjectsGenerator outlineVariedColors(int numberColors, int outlineWidth, DisplayStack background) {
        return DrawObjectsGenerator.outlineVariedColors(numberColors, outlineWidth, (Either<Dimensions, DisplayStack>)Either.right((Object)background));
    }

    public static DrawObjectsGenerator outlineWithColorIndex(int outlineWidth, ColorIndex colorIndex) {
        return new DrawObjectsGenerator((DrawObject)new Outline(outlineWidth), null, colorIndex);
    }

    public static DrawObjectsGenerator outlineVariedColors(int numberColors, int outlineWidth, Either<Dimensions, DisplayStack> background) {
        return new DrawObjectsGenerator((DrawObject)new Outline(outlineWidth), background, DrawObjectsGenerator.defaultColorsFor(numberColors));
    }

    public static DrawObjectsGenerator outlineSingleColor(int outlineWidth, DisplayStack background, RGBColor color) {
        return new DrawObjectsGenerator((DrawObject)new Outline(outlineWidth), (Either<Dimensions, DisplayStack>)Either.right((Object)background), DrawObjectsGenerator.singleColorIndex(color));
    }

    @Override
    protected RGBStack generateBackgroundRegion(ObjectCollectionWithProperties objects, Either<Dimensions, DisplayStack> background) {
        return (RGBStack)background.fold(ObjectsAsRGBGenerator::createEmptyStackFor, stack -> ConvertStackToRGB.convert(stack, true));
    }

    @Override
    protected ObjectCollectionWithProperties generateMasks(ObjectCollectionWithProperties objects) {
        return objects;
    }

    private static ColorIndex defaultColorsFor(int size) {
        return new HSB().createList(size);
    }

    private static ColorIndex singleColorIndex(RGBColor color) {
        return new ColorIndexModulo((ColorIndex)new ColorList(new RGBColor[]{color}));
    }
}

