/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.object.output.mask;

import java.util.Optional;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributes;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributesFactory;
import org.anchoranalysis.image.io.stack.output.generator.RasterGeneratorSelectFormat;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3i;

public class ObjectAsMaskGenerator
extends RasterGeneratorSelectFormat<ObjectMask> {
    private final Optional<Resolution> resolution;

    public ObjectAsMaskGenerator() {
        this(Optional.empty());
    }

    public Stack transform(ObjectMask element) throws OutputWriteFailedException {
        return new Stack(ObjectAsMaskGenerator.createChannelFromMask(element, this.resolution));
    }

    @Override
    public StackWriteAttributes guaranteedImageAttributes() {
        return StackWriteAttributesFactory.binaryChannel(false);
    }

    private static Channel createChannelFromMask(ObjectMask objectMask, Optional<Resolution> resolution) {
        byte outOnValue = BinaryValuesByte.getDefault().getOn();
        BoundingBox box = objectMask.boundingBox();
        Dimensions dimensions = new Dimensions(box.extent(), resolution);
        Channel channelNew = ChannelFactory.instance().create(dimensions, (VoxelDataType)UnsignedByteVoxelType.INSTANCE);
        Voxels voxelsNew = channelNew.voxels().asByte();
        byte matchValue = objectMask.binaryValuesByte().getOn();
        byte outOnValueByte = outOnValue;
        Point3i pointLocal = new Point3i();
        pointLocal.setZ(0);
        while (pointLocal.z() < dimensions.z()) {
            UnsignedByteBuffer pixelsIn = objectMask.sliceBufferLocal(pointLocal.z());
            UnsignedByteBuffer pixelsOut = (UnsignedByteBuffer)voxelsNew.sliceBuffer(pointLocal.z());
            while (pixelsIn.hasRemaining()) {
                if (pixelsIn.getRaw() != matchValue) continue;
                pixelsOut.putRaw(pixelsIn.position() - 1, outOnValueByte);
            }
            pointLocal.incrementZ();
        }
        return channelNew;
    }

    public ObjectAsMaskGenerator(Optional<Resolution> resolution) {
        this.resolution = resolution;
    }
}

