/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.object.output.hdf5;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.io.object.output.hdf5.ObjectMaskHDF5Writer;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.io.generator.OneStageGenerator;
import org.anchoranalysis.io.output.bean.OutputWriteSettings;

public class HDF5ObjectsGenerator
extends OneStageGenerator<ObjectCollection> {
    public static final String NUMBER_OBJECTS_ATTRIBUTE_NAME = "numberObjects";
    private final boolean compressed;

    public HDF5ObjectsGenerator() {
        this.compressed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(ObjectCollection element, OutputWriteSettings settings, Path filePath) {
        HDF5ObjectsGenerator.addObjectsSizeAttribute(writer, element);
        try (IHDF5Writer writer = HDF5Factory.open((String)filePath.toString());){
            for (int i = 0; i < element.size(); ++i) {
                ObjectMaskHDF5Writer writerHDF5 = new ObjectMaskHDF5Writer(element.get(i), HDF5ObjectsGenerator.pathForObject(i), writer, this.compressed);
                writerHDF5.writeObject();
            }
        }
    }

    public String selectFileExtension(OutputWriteSettings settings, Optional<Logger> logger) {
        return "h5";
    }

    private static void addObjectsSizeAttribute(IHDF5Writer writer, ObjectCollection objects) {
        writer.uint32().setAttr("/", NUMBER_OBJECTS_ATTRIBUTE_NAME, objects.size());
    }

    private static String pathForObject(int index) {
        return String.format("%s/%08d", "/ObjMaskCollection/", index);
    }

    public HDF5ObjectsGenerator(boolean compressed) {
        this.compressed = compressed;
    }
}

