/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.object;

import org.anchoranalysis.image.core.object.properties.ObjectWithProperties;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class ExtractMidpoint {
    private static final String PROPERTY_MIDPOINT = "midpointInt";

    public static Point3i midpoint(ObjectWithProperties object, boolean suppressZ) {
        return ExtractMidpoint.maybeSuppressZ(ExtractMidpoint.calculateMidpoint3D(object), suppressZ);
    }

    private static Point3i maybeSuppressZ(Point3i point, boolean suppressZ) {
        if (suppressZ) {
            point.setZ(0);
        }
        return point;
    }

    private static Point3i calculateMidpoint3D(ObjectWithProperties object) {
        if (object.hasProperty(PROPERTY_MIDPOINT)) {
            return Point3i.immutableAdd((ReadableTuple3i)((ReadableTuple3i)object.getProperty(PROPERTY_MIDPOINT)), (ReadableTuple3i)object.boundingBox().cornerMin());
        }
        return PointConverter.intFromDoubleFloor((Point3d)object.asObjectMask().centerOfGravity());
    }

    private ExtractMidpoint() {
    }
}

