/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.histogram.output;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.io.generator.tabular.CSVWriter;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.math.histogram.Histogram;

class HistogramCSVWriter {
    private static final List<String> HEADERS = Arrays.asList("intensity", "count");

    public static void writeHistogramToFile(Histogram histogram, Path filePath, boolean ignoreZeros) throws OutputWriteFailedException {
        try (CSVWriter writer = CSVWriter.create((Path)filePath);){
            writer.writeHeaders(HEADERS);
            histogram.iterateValues((bin, count) -> {
                if (!ignoreZeros || count != 0) {
                    writer.writeRow(HistogramCSVWriter.createTypedValues(bin, count));
                }
            });
        }
    }

    private static List<TypedValue> createTypedValues(int bin, int count) {
        return Arrays.asList(new TypedValue((double)bin, 0), new TypedValue((double)count, 0));
    }

    private HistogramCSVWriter() {
    }
}

