/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.histogram.input;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.io.input.csv.CSVReaderByLine;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.io.input.csv.ReadByLine;
import org.anchoranalysis.math.histogram.Histogram;

public class HistogramCSVReader {
    public static Histogram readHistogramFromFile(Path filePath) throws CSVReaderException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        try (ReadByLine reader = CSVReaderByLine.open((Path)filePath);){
            reader.read((line, firstLine) -> HistogramCSVReader.addLineToMap(map, line));
        }
        return HistogramCSVReader.histogramFromMap(map);
    }

    private static void addLineToMap(Map<Integer, Integer> map, String[] line) throws OperationFailedException {
        int count;
        int bin;
        float binAsFloat = Float.parseFloat(line[0]);
        if (binAsFloat != (float)(bin = (int)binAsFloat)) {
            throw new OperationFailedException(String.format("Bin-value of %f is not integer.", Float.valueOf(binAsFloat)));
        }
        float countAsFloat = Float.parseFloat(line[1]);
        if (countAsFloat != (float)(count = (int)countAsFloat)) {
            throw new OperationFailedException(String.format("Count-value of %f is not integer.", Float.valueOf(countAsFloat)));
        }
        if (map.containsKey(bin)) {
            throw new OperationFailedException(String.format("There are multiple bins of value %d", bin));
        }
        map.put(bin, count);
    }

    private static int maxValue(Set<Integer> set) {
        return set.stream().mapToInt(Integer::intValue).max().getAsInt();
    }

    private static Histogram histogramFromMap(Map<Integer, Integer> map) throws CSVReaderException {
        int maxCsvValue = HistogramCSVReader.maxValue(map.keySet());
        int maxHistogramValue = HistogramCSVReader.guessMaxHistogramBin(maxCsvValue);
        Histogram histogram = new Histogram(maxHistogramValue);
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            histogram.incrementValueBy(entry.getKey().intValue(), entry.getValue().intValue());
        }
        return histogram;
    }

    private static int guessMaxHistogramBin(int maxCsvBin) throws CSVReaderException {
        if ((long)maxCsvBin <= 255L) {
            return 255;
        }
        if ((long)maxCsvBin <= 65535L) {
            return 65535;
        }
        throw new CSVReaderException("Histograms can only supported for a maximum-value of 65535");
    }

    private HistogramCSVReader() {
    }
}

