/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.channel.map;

import java.util.Optional;
import java.util.Set;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.identifier.provider.store.StoreSupplier;
import org.anchoranalysis.core.index.GetOperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.core.stack.named.NamedStacks;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.channel.IndexedChannel;
import org.anchoranalysis.image.io.channel.input.ChannelMap;
import org.anchoranalysis.image.io.channel.map.NamedChannelsMap;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.image.io.stack.time.TimeSeries;

public class OpenedNamedChannels
implements NamedChannelsMap {
    private final OpenedImageFile openedFile;
    private final ChannelMap channelMap;
    private final int seriesIndex;
    private TimeSeries timeSeries;

    @Override
    public Dimensions dimensions(Logger logger) throws ImageIOException {
        return this.openedFile.dimensionsForSeries(this.seriesIndex, logger);
    }

    @Override
    public Channel getChannel(String channelName, int timeIndex, Logger logger) throws GetOperationFailedException {
        int index = this.channelMap.get(channelName);
        if (index == -1) {
            throw new GetOperationFailedException(channelName, String.format("'%s' cannot be found", channelName));
        }
        try {
            Stack stack = this.createTimeSeries(logger).getFrame(timeIndex);
            if (index >= stack.getNumberChannels()) {
                throw new GetOperationFailedException(channelName, String.format("Stack does not have a channel corresponding to '%s'", channelName));
            }
            return stack.getChannel(this.channelMap.getException(channelName));
        }
        catch (OperationFailedException e) {
            throw new GetOperationFailedException(channelName, (Throwable)e);
        }
    }

    @Override
    public Optional<Channel> getChannelOptional(String channelName, int timeIndex, Logger logger) throws GetOperationFailedException {
        int index = this.channelMap.get(channelName);
        if (index == -1) {
            return Optional.empty();
        }
        try {
            Stack stack = this.createTimeSeries(logger).getFrame(timeIndex);
            if (index >= stack.getNumberChannels()) {
                return Optional.empty();
            }
            return Optional.of(stack.getChannel(index));
        }
        catch (OperationFailedException e) {
            throw new GetOperationFailedException(channelName, (Throwable)e);
        }
    }

    @Override
    public int sizeT(Logger logger) throws ImageIOException {
        try {
            return this.createTimeSeries(logger).size();
        }
        catch (OperationFailedException e) {
            throw new ImageIOException("Cannot establish the size of the time-dimension", e);
        }
    }

    @Override
    public Set<String> channelNames() {
        return this.channelMap.names();
    }

    @Override
    public int numberChannels() {
        return this.channelMap.names().size();
    }

    @Override
    public boolean hasChannel(String channelName) {
        return this.channelMap.names().contains(channelName);
    }

    @Override
    public void addAsSeparateChannels(NamedStacks destination, int timeIndex, Logger logger) throws OperationFailedException {
        try {
            for (String channelName : this.channelMap.names()) {
                Channel image = this.getChannel(channelName, timeIndex, logger);
                destination.add(channelName, new Stack(image));
            }
        }
        catch (GetOperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public void addAsSeparateChannels(NamedProviderStore<TimeSeries> destination, int timeIndex, Logger logger) throws OperationFailedException {
        for (String channelName : this.channelMap.names()) {
            destination.add(channelName, StoreSupplier.cache(() -> this.extractChannelAsTimeSeries(channelName, timeIndex, logger)));
        }
    }

    @Override
    public boolean isRGB(Logger logger) throws ImageIOException {
        return this.openedFile.isRGB(logger);
    }

    @Override
    public StoreSupplier<Stack> allChannelsAsStack(int t, Logger logger) {
        return StoreSupplier.cache(() -> this.stackForAllChannels(t, logger));
    }

    private TimeSeries createTimeSeries(Logger logger) throws OperationFailedException {
        if (this.timeSeries == null) {
            try {
                this.timeSeries = this.openedFile.open(this.seriesIndex, logger);
            }
            catch (ImageIOException e) {
                throw new OperationFailedException((Throwable)((Object)e));
            }
        }
        return this.timeSeries;
    }

    private Stack stackForAllChannels(int timeIndex, Logger logger) throws OperationFailedException {
        Stack out = new Stack();
        for (IndexedChannel entry : this.channelMap.values()) {
            try {
                out.addChannel(this.getChannel(entry.getName(), timeIndex, logger));
            }
            catch (GetOperationFailedException | IncorrectImageSizeException e) {
                throw new OperationFailedException(e);
            }
        }
        return out;
    }

    private TimeSeries extractChannelAsTimeSeries(String channelName, int timeIndex, Logger logger) throws OperationFailedException {
        try {
            Channel image = this.getChannel(channelName, timeIndex, logger);
            return new TimeSeries(new Stack(image));
        }
        catch (GetOperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public OpenedNamedChannels(OpenedImageFile openedFile, ChannelMap channelMap, int seriesIndex) {
        this.openedFile = openedFile;
        this.channelMap = channelMap;
        this.seriesIndex = seriesIndex;
    }
}

