/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.channel.map;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.identifier.provider.store.StoreSupplier;
import org.anchoranalysis.core.index.GetOperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.core.stack.named.NamedStacks;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.channel.map.NamedChannelsMap;
import org.anchoranalysis.image.io.stack.time.TimeSeries;

public class NamedChannelsConcatenate
implements NamedChannelsMap {
    private final List<NamedChannelsMap> list;

    public NamedChannelsConcatenate(NamedChannelsMap ... maps) {
        this.list = Arrays.stream(maps).collect(Collectors.toList());
    }

    @Override
    public Channel getChannel(String channelName, int timeIndex, Logger logger) throws GetOperationFailedException {
        for (NamedChannelsMap item : this.list) {
            Optional<Channel> channel = item.getChannelOptional(channelName, timeIndex, logger);
            if (!channel.isPresent()) continue;
            return channel.get();
        }
        throw new GetOperationFailedException(channelName, String.format("channelName '%s' is not found", channelName));
    }

    @Override
    public Optional<Channel> getChannelOptional(String channelName, int timeIndex, Logger logger) throws GetOperationFailedException {
        for (NamedChannelsMap item : this.list) {
            Optional<Channel> channel = item.getChannelOptional(channelName, timeIndex, logger);
            if (!channel.isPresent()) continue;
            return channel;
        }
        return Optional.empty();
    }

    @Override
    public void addAsSeparateChannels(NamedStacks stackCollection, int t, Logger logger) throws OperationFailedException {
        for (NamedChannelsMap item : this.list) {
            item.addAsSeparateChannels(stackCollection, t, logger);
        }
    }

    @Override
    public void addAsSeparateChannels(NamedProviderStore<TimeSeries> stackCollection, int timeIndex, Logger logger) throws OperationFailedException {
        for (NamedChannelsMap item : this.list) {
            item.addAsSeparateChannels(stackCollection, timeIndex, logger);
        }
    }

    @Override
    public int numberChannels() {
        return this.list.stream().mapToInt(NamedChannelsMap::numberChannels).sum();
    }

    @Override
    public Set<String> channelNames() {
        HashSet<String> set = new HashSet<String>();
        for (NamedChannelsMap item : this.list) {
            set.addAll(item.channelNames());
        }
        return set;
    }

    @Override
    public int sizeT(Logger logger) throws ImageIOException {
        int series = 0;
        boolean first = true;
        for (NamedChannelsMap item : this.list) {
            if (first) {
                series = item.sizeT(logger);
                first = false;
                continue;
            }
            series = Math.min(series, item.sizeT(logger));
        }
        return series;
    }

    @Override
    public boolean hasChannel(String channelName) {
        for (NamedChannelsMap item : this.list) {
            if (!item.channelNames().contains(channelName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Dimensions dimensions(Logger logger) throws ImageIOException {
        return this.list.get(0).dimensions(logger);
    }

    @Override
    public StoreSupplier<Stack> allChannelsAsStack(int t, Logger logger) {
        return StoreSupplier.cache(() -> this.stackAllChannels(t, logger));
    }

    @Override
    public boolean isRGB(Logger logger) throws ImageIOException {
        return false;
    }

    private Stack stackAllChannels(int timeIndex, Logger logger) throws OperationFailedException {
        Stack out = new Stack();
        for (NamedChannelsMap namedChannels : this.list) {
            try {
                NamedChannelsConcatenate.addAllChannelsFrom((Stack)namedChannels.allChannelsAsStack(timeIndex, logger).get(), out);
            }
            catch (IncorrectImageSizeException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        return out;
    }

    private static void addAllChannelsFrom(Stack source, Stack destination) throws IncorrectImageSizeException {
        for (Channel channel : source) {
            destination.addChannel(channel);
        }
    }
}

