/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.channel.input;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.identifier.provider.store.StoreSupplier;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.channel.map.NamedChannelsMap;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.image.io.stack.time.TimeSeries;

public abstract class NamedChannelsInput
implements ProvidesStackInput {
    public abstract int numberSeries() throws ImageIOException;

    public abstract Dimensions dimensions(int var1, Logger var2) throws ImageIOException;

    public abstract int numberChannels(Logger var1) throws ImageIOException;

    public abstract int bitDepth(Logger var1) throws ImageIOException;

    public abstract NamedChannelsMap createChannelsForSeries(int var1, Logger var2) throws ImageIOException;

    public abstract ImageMetadata metadata(int var1, Logger var2) throws ImageIOException;

    @Override
    public void addToStoreInferNames(NamedProviderStore<TimeSeries> stacks, int seriesIndex, Logger logger) throws OperationFailedException {
        try {
            NamedChannelsMap namedChannels = this.createChannelsForSeries(seriesIndex, logger);
            namedChannels.addAsSeparateChannels(stacks, 0, logger);
        }
        catch (ImageIOException e) {
            throw new OperationFailedException((Throwable)((Object)e));
        }
    }

    @Override
    public void addToStoreWithName(String name, NamedProviderStore<TimeSeries> stacks, int seriesIndex, Logger logger) throws OperationFailedException {
        stacks.add(name, StoreSupplier.cache(() -> this.channelsAsTimeSequence(seriesIndex, logger)));
    }

    @Override
    public int numberFrames() {
        return 1;
    }

    private TimeSeries channelsAsTimeSequence(int seriesIndex, Logger logger) throws OperationFailedException {
        try {
            NamedChannelsMap namedChannels = this.createChannelsForSeries(seriesIndex, logger);
            return new TimeSeries((Stack)namedChannels.allChannelsAsStack(0, logger).get());
        }
        catch (ImageIOException e) {
            throw new OperationFailedException((Throwable)((Object)e));
        }
    }
}

