/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.bean.stack.writer;

import java.nio.file.Path;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.format.FileFormatFactory;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.writer.StackWriter;
import org.anchoranalysis.image.io.stack.output.StackRGBState;
import org.anchoranalysis.image.io.stack.output.StackWriteOptions;

public abstract class OneOrThreeChannelsWriter
extends StackWriter {
    @BeanField
    private String extension = "png";

    @Override
    public ImageFileFormat fileFormat(StackWriteOptions writeOptions) throws ImageIOException {
        return (ImageFileFormat)FileFormatFactory.createImageFormat((String)this.extension).orElseThrow(() -> new ImageIOException(String.format("The extension %s is not associated with a recognised format", this.extension)));
    }

    @Override
    public void writeStack(Stack stack, Path filePath, StackWriteOptions options) throws ImageIOException {
        if (stack.getNumberChannels() == 3 && options.getAttributes().getRgb() != StackRGBState.RGB_WITHOUT_ALPHA) {
            throw new ImageIOException("3-channel images can only be created as RGB");
        }
        this.writeStackAfterCheck(stack, filePath);
    }

    protected abstract void writeStackAfterCheck(Stack var1, Path var2) throws ImageIOException;

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}

