/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.bean.stack.combine;

import java.awt.image.BufferedImage;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.bean.spatial.SizeXY;
import org.anchoranalysis.image.core.bufferedimage.CreateStackFromBufferedImage;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.convert.ConversionPolicy;
import org.anchoranalysis.image.core.channel.convert.ToUnsignedShort;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.bean.stack.combine.TextStyle;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributes;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributesFactory;
import org.anchoranalysis.image.io.stack.output.generator.RasterGeneratorSelectFormat;
import org.anchoranalysis.image.voxel.convert.ToUnsignedShortScaleByType;
import org.anchoranalysis.image.voxel.convert.VoxelsConverter;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.spatial.box.BoundingBox;

public class WriteText
extends StackProvider {
    @BeanField
    private String text = "text";
    @BeanField
    private TextStyle style;
    @BeanField
    private SizeXY size;
    @BeanField
    private boolean createShort;
    @BeanField
    private Provider<Stack> repeatZProvider;

    public WriteText(String text) {
        this.text = text;
    }

    public Stack get() throws ProvisionFailedException {
        Stack label2D = this.create2D();
        if (this.repeatZProvider != null) {
            Stack repeatZ = (Stack)this.repeatZProvider.get();
            int zHeight = repeatZ.dimensions().z();
            Stack out = new Stack();
            for (Channel channel : label2D) {
                try {
                    out.addChannel(this.createExpandedChannel(channel, zHeight));
                }
                catch (IncorrectImageSizeException e) {
                    throw new ProvisionFailedException((Throwable)e);
                }
            }
            return out;
        }
        return label2D;
    }

    private Stack create2D() throws ProvisionFailedException {
        try {
            Stack stack = new RasterizedTextGenerator(this.size, this.style).transform(this.text);
            if (this.createShort) {
                ToUnsignedShort conveter = new ToUnsignedShort((VoxelsConverter)new ToUnsignedShortScaleByType());
                stack = conveter.convert(stack, ConversionPolicy.CHANGE_EXISTING_CHANNEL);
            }
            return stack;
        }
        catch (OutputWriteFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private Channel createExpandedChannel(Channel channel, int zHeight) {
        BoundingBox boxSrc;
        assert (channel.dimensions().z() == 1);
        BoundingBox boxDest = boxSrc = new BoundingBox(channel.extent());
        Channel channelNew = this.emptyChannelWithChangedZ(channel, zHeight);
        for (int z = 0; z < zHeight; ++z) {
            boxDest = boxDest.shiftToZ(z);
            channel.voxels().copyVoxelsTo(boxSrc, channelNew.voxels(), boxDest);
        }
        return channelNew;
    }

    private Channel emptyChannelWithChangedZ(Channel channel, int zToAssign) {
        Dimensions dimensionsChangedZ = channel.dimensions().duplicateChangeZ(zToAssign);
        return ChannelFactory.instance().create(dimensionsChangedZ, channel.getVoxelDataType());
    }

    public WriteText() {
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public void setStyle(TextStyle style) {
        this.style = style;
    }

    public SizeXY getSize() {
        return this.size;
    }

    public void setSize(SizeXY size) {
        this.size = size;
    }

    public boolean isCreateShort() {
        return this.createShort;
    }

    public void setCreateShort(boolean createShort) {
        this.createShort = createShort;
    }

    public Provider<Stack> getRepeatZProvider() {
        return this.repeatZProvider;
    }

    public void setRepeatZProvider(Provider<Stack> repeatZProvider) {
        this.repeatZProvider = repeatZProvider;
    }

    private static class RasterizedTextGenerator
    extends RasterGeneratorSelectFormat<String> {
        private final SizeXY size;
        private final TextStyle style;

        public Stack transform(String element) throws OutputWriteFailedException {
            BufferedImage bufferedImage = new BufferedImage(this.size.getWidth(), this.size.getHeight(), 1);
            this.style.drawText(element, bufferedImage, this.size.asExtent());
            try {
                return CreateStackFromBufferedImage.createFrom((BufferedImage)bufferedImage);
            }
            catch (OperationFailedException e) {
                throw new OutputWriteFailedException((Throwable)e);
            }
        }

        @Override
        public StackWriteAttributes guaranteedImageAttributes() {
            return StackWriteAttributesFactory.rgbMaybe3D(false);
        }

        public RasterizedTextGenerator(SizeXY size, TextStyle style) {
            this.size = size;
            this.style = style;
        }
    }
}

