/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.bean.object.feature;

import java.nio.file.Path;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.SharedObjects;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListFactory;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.io.csv.table.FeatureTableCSVGenerator;
import org.anchoranalysis.feature.io.csv.table.FeatureTableCSVGeneratorFactory;
import org.anchoranalysis.feature.name.FeatureNameList;
import org.anchoranalysis.feature.results.ResultsVectorList;
import org.anchoranalysis.image.core.dimensions.SpatialUnits;
import org.anchoranalysis.image.feature.bean.evaluator.FeatureListEvaluator;
import org.anchoranalysis.image.feature.bean.object.single.CenterOfGravity;
import org.anchoranalysis.image.feature.bean.object.single.NumberVoxels;
import org.anchoranalysis.image.feature.bean.physical.ConvertToPhysicalDistance;
import org.anchoranalysis.image.feature.calculator.NamedFeatureCalculatorMulti;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.generator.tabular.CSVGenerator;
import org.anchoranalysis.io.output.bean.OutputWriteSettings;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.orientation.DirectionVector;

class ObjectFeatureListCSVGenerator
extends CSVGenerator<ObjectCollection> {
    private FeatureCalculatorMulti<FeatureInputSingleObject> featureCalculator;
    private FeatureTableCSVGenerator<ResultsVectorList> delegate;
    private final Logger logger;

    public ObjectFeatureListCSVGenerator(FeatureListEvaluator<FeatureInputSingleObject> featureEvaluator, SharedObjects sharedObjects, Logger logger) throws CreateException {
        this.logger = logger;
        try {
            NamedFeatureCalculatorMulti tuple = featureEvaluator.createFeatureSession(this::createFullFeatureList, sharedObjects);
            this.featureCalculator = tuple.getCalculator();
            this.delegate = FeatureTableCSVGeneratorFactory.create((FeatureNameList)tuple.getNames(), (boolean)false);
        }
        catch (OperationFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    public void writeToFile(ObjectCollection element, OutputWriteSettings settings, Path filePath) throws OutputWriteFailedException {
        ResultsVectorList results = new ResultsVectorList();
        for (ObjectMask objectMask : element) {
            results.add(this.featureCalculator.calculateSuppressErrors((FeatureInput)new FeatureInputSingleObject(objectMask), this.logger.errorReporter()));
        }
        this.delegate.writeToFile((Object)results, settings, filePath);
    }

    private FeatureList<FeatureInputSingleObject> createFullFeatureList(FeatureList<FeatureInputSingleObject> features) {
        StreamEx stream = StreamEx.of(ObjectFeatureListCSVGenerator.addFeaturesForAxis(Axis.X));
        stream.append(ObjectFeatureListCSVGenerator.addFeaturesForAxis(Axis.Y));
        stream.append(ObjectFeatureListCSVGenerator.addFeaturesForAxis(Axis.Z));
        stream.append(this.createNumVoxels());
        stream.append(features.asList().stream().map(ObjectFeatureListCSVGenerator::duplicateSetCustomNameIfMissing));
        return FeatureListFactory.fromStream((Stream)stream);
    }

    private Feature<FeatureInputSingleObject> createNumVoxels() {
        NumberVoxels feature = new NumberVoxels();
        feature.setCustomName("numVoxels");
        return feature;
    }

    private static <T extends FeatureInput> Feature<T> duplicateSetCustomNameIfMissing(Feature<T> feature) {
        if (feature.getCustomName() == null || feature.getCustomName().isEmpty()) {
            return feature.duplicateChangeName(feature.getFriendlyName());
        }
        return (Feature)feature.duplicateBean();
    }

    private static Stream<Feature<FeatureInputSingleObject>> addFeaturesForAxis(Axis axis) {
        CenterOfGravity feature = new CenterOfGravity(axis);
        Feature<FeatureInputSingleObject> featurePhysical = ObjectFeatureListCSVGenerator.convertToPhysical((Feature<FeatureInputSingleObject>)feature, new DirectionVector(axis));
        String axisLabel = axis.toString().toLowerCase();
        feature.setCustomName(axisLabel);
        featurePhysical.setCustomName(axisLabel + "_p");
        return Stream.of(feature, featurePhysical);
    }

    private static Feature<FeatureInputSingleObject> convertToPhysical(Feature<FeatureInputSingleObject> feature, DirectionVector dir) {
        return new ConvertToPhysicalDistance(feature, SpatialUnits.UnitSuffix.MICRO, dir);
    }
}

