/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.bean.object.draw;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.contour.FindContour;
import org.anchoranalysis.image.core.object.properties.ObjectWithProperties;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.io.bean.object.draw.IntersectionWriter;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.overlay.bean.DrawObject;
import org.anchoranalysis.overlay.writer.ObjectDrawAttributes;
import org.anchoranalysis.spatial.box.BoundingBox;

public class Outline
extends DrawObject {
    @BeanField
    private int outlineWidth;
    @BeanField
    private boolean includeZ;

    public Outline() {
        this(1);
    }

    public Outline(int outlineWidth) {
        this(outlineWidth, true);
    }

    public void drawSingle(ObjectWithProperties object, RGBStack stack, ObjectDrawAttributes attributes, int iteration, BoundingBox restrictTo) throws OperationFailedException {
        ObjectMask outline = FindContour.createFrom((ObjectMask)object.asObjectMask(), (int)this.outlineWidth, (stack.dimensions().z() > 1 && this.includeZ ? 1 : 0) != 0, (boolean)true);
        ObjectWithProperties objectWithProperties = new ObjectWithProperties(outline, object.getProperties());
        IntersectionWriter.writeRGBMaskIntersection(outline, attributes.colorFor(objectWithProperties, iteration), stack, restrictTo);
    }

    public Outline(int outlineWidth, boolean includeZ) {
        this.outlineWidth = outlineWidth;
        this.includeZ = includeZ;
    }

    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(int outlineWidth) {
        this.outlineWidth = outlineWidth;
    }

    public boolean isIncludeZ() {
        return this.includeZ;
    }

    public void setIncludeZ(boolean includeZ) {
        this.includeZ = includeZ;
    }
}

