/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.bean.object.draw;

import com.google.common.base.Preconditions;
import org.anchoranalysis.core.color.RGBColor;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class IntersectionWriter {
    public static void writeRGBMaskIntersection(ObjectMask object, RGBColor color, RGBStack stack, BoundingBox stackBox) throws OperationFailedException {
        if (!stackBox.intersection().existsWith(object.boundingBox())) {
            throw new OperationFailedException(String.format("The bounding-box of the object-mask (%s) does not intersect with the stack (%s)", object.boundingBox().toString(), stackBox.toString()));
        }
        BoundingBox intersection = (BoundingBox)object.boundingBox().intersection().with(stackBox).orElseThrow(() -> new OperationFailedException("Bounding boxes of object and stack do not intersect"));
        IntersectionWriter.writeOnEachSlice(stack, color, intersection.shiftBackBy(stackBox.cornerMin()), object.shiftBackBy(stackBox.cornerMin()));
    }

    private static void writeOnEachSlice(RGBStack stack, RGBColor color, BoundingBox intersection, ObjectMask object) {
        ReadableTuple3i maxGlobal = intersection.calculateCornerMaxInclusive();
        Point3i pointGlobal = new Point3i();
        pointGlobal.setZ(intersection.cornerMin().z());
        while (pointGlobal.z() <= maxGlobal.z()) {
            int relZ = pointGlobal.z() - object.boundingBox().cornerMin().z();
            IntersectionWriter.writeRGBMaskToSlice(stack, object, intersection, color, pointGlobal, relZ, maxGlobal);
            pointGlobal.incrementZ();
        }
    }

    private static void writeRGBMaskToSlice(RGBStack stack, ObjectMask object, BoundingBox box, RGBColor color, Point3i pointGlobal, int zLocal, ReadableTuple3i maxGlobal) {
        Preconditions.checkArgument((pointGlobal.z() >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)stack.allChannelsHaveType((VoxelDataType)UnsignedByteVoxelType.INSTANCE));
        byte objectMaskOn = object.binaryValuesByte().getOn();
        UnsignedByteBuffer inArr = object.sliceBufferLocal(zLocal);
        UnsignedByteBuffer red = stack.sliceBuffer(0, pointGlobal.z());
        UnsignedByteBuffer green = stack.sliceBuffer(1, pointGlobal.z());
        UnsignedByteBuffer blue = stack.sliceBuffer(2, pointGlobal.z());
        Extent extentMask = object.boundingBox().extent();
        pointGlobal.setY(box.cornerMin().y());
        while (pointGlobal.y() <= maxGlobal.y()) {
            pointGlobal.setX(box.cornerMin().x());
            while (pointGlobal.x() <= maxGlobal.x()) {
                int objectMaskOffset = extentMask.offset(pointGlobal.x() - object.boundingBox().cornerMin().x(), pointGlobal.y() - object.boundingBox().cornerMin().y());
                if (inArr.getRaw(objectMaskOffset) == objectMaskOn) {
                    IntersectionWriter.writeColoredVoxel(color, pointGlobal, stack.getChannel(0).dimensions(), red, blue, green);
                }
                pointGlobal.incrementX();
            }
            pointGlobal.incrementY();
        }
    }

    private static void writeColoredVoxel(RGBColor color, Point3i point, Dimensions dimensions, UnsignedByteBuffer red, UnsignedByteBuffer blue, UnsignedByteBuffer green) {
        int index = dimensions.offsetSlice(point);
        red.putUnsigned(index, color.getRed());
        green.putUnsigned(index, color.getGreen());
        blue.putUnsigned(index, color.getBlue());
    }

    private IntersectionWriter() {
    }
}

