/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.segment;

import java.util.function.Function;
import lombok.Generated;

public class WithConfidence<T>
implements Comparable<WithConfidence<T>> {
    private T element;
    private double confidence;

    public <S> WithConfidence<S> map(Function<T, S> transform) {
        return new WithConfidence<S>(transform.apply(this.element), this.confidence);
    }

    @Override
    public int compareTo(WithConfidence<T> other) {
        return Double.compare(other.confidence, this.confidence);
    }

    public String toString() {
        return String.format("confidence=%.2f, %s", this.confidence, this.element);
    }

    @Generated
    public WithConfidence(T element, double confidence) {
        this.element = element;
        this.confidence = confidence;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WithConfidence)) {
            return false;
        }
        WithConfidence other = (WithConfidence)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getConfidence(), other.getConfidence()) != 0) {
            return false;
        }
        T this$element = this.getElement();
        T other$element = other.getElement();
        return !(this$element == null ? other$element != null : !this$element.equals(other$element));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WithConfidence;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $confidence = Double.doubleToLongBits(this.getConfidence());
        result = result * 59 + (int)($confidence >>> 32 ^ $confidence);
        T $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : $element.hashCode());
        return result;
    }

    @Generated
    public T getElement() {
        return this.element;
    }

    @Generated
    public double getConfidence() {
        return this.confidence;
    }
}

