/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.segment;

import java.util.function.Function;
import lombok.Generated;
import org.anchoranalysis.image.inference.segment.WithConfidence;

public class LabelledWithConfidence<T>
implements Comparable<LabelledWithConfidence<T>> {
    private final String label;
    private final WithConfidence<T> withConfidence;

    public LabelledWithConfidence(T element, double confidence, String label) {
        this.withConfidence = new WithConfidence<T>(element, confidence);
        this.label = label;
    }

    public <S> LabelledWithConfidence<S> map(Function<T, S> transform) {
        S transformed = transform.apply(this.withConfidence.getElement());
        return new LabelledWithConfidence<S>(transformed, this.withConfidence.getConfidence(), this.label);
    }

    public T getElement() {
        return this.withConfidence.getElement();
    }

    public double getConfidence() {
        return this.withConfidence.getConfidence();
    }

    @Override
    public int compareTo(LabelledWithConfidence<T> other) {
        int confidenceComparison = this.withConfidence.compareTo(other.withConfidence);
        if (confidenceComparison == 0) {
            return this.label.compareTo(other.label);
        }
        return confidenceComparison;
    }

    public String toString() {
        return String.format("label=%s,%s", this.label, this.withConfidence);
    }

    @Generated
    public LabelledWithConfidence(String label, WithConfidence<T> withConfidence) {
        this.label = label;
        this.withConfidence = withConfidence;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LabelledWithConfidence)) {
            return false;
        }
        LabelledWithConfidence other = (LabelledWithConfidence)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        WithConfidence<T> this$withConfidence = this.getWithConfidence();
        WithConfidence<T> other$withConfidence = other.getWithConfidence();
        return !(this$withConfidence == null ? other$withConfidence != null : !((Object)this$withConfidence).equals(other$withConfidence));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LabelledWithConfidence;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        WithConfidence<T> $withConfidence = this.getWithConfidence();
        result = result * 59 + ($withConfidence == null ? 43 : ((Object)$withConfidence).hashCode());
        return result;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public WithConfidence<T> getWithConfidence() {
        return this.withConfidence;
    }
}

