/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.bean.segment.instance;

import java.util.List;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.inference.ImageInferenceContext;
import org.anchoranalysis.image.inference.ImageInferenceModel;
import org.anchoranalysis.image.inference.bean.segment.instance.DecodeInstanceSegmentation;
import org.anchoranalysis.image.inference.bean.segment.instance.InferenceExecutionTimeRecorder;
import org.anchoranalysis.image.inference.segment.LabelledWithConfidence;
import org.anchoranalysis.image.inference.segment.MultiScaleObject;
import org.anchoranalysis.inference.concurrency.ConcurrentModel;
import org.anchoranalysis.inference.concurrency.ConcurrentModelException;
import org.anchoranalysis.inference.concurrency.ConcurrentModelPool;

class InferenceHelper<T, S extends ImageInferenceModel<T>> {
    private final DecodeInstanceSegmentation<T> decode;
    private final String inputName;

    public List<LabelledWithConfidence<MultiScaleObject>> queueInference(T inputTensor, ConcurrentModelPool<S> modelPool, ImageInferenceContext context) throws Throwable {
        return (List)modelPool.executeOrWait(model -> this.performInference((ConcurrentModel<S>)model, inputTensor, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LabelledWithConfidence<MultiScaleObject>> performInference(ConcurrentModel<S> model, T inputTensor, ImageInferenceContext context) throws ConcurrentModelException {
        InferenceExecutionTimeRecorder recorder = new InferenceExecutionTimeRecorder(context.getExecutionTimeRecorder(), model.isGpu());
        recorder.recordStartInference();
        try {
            List list = (List)((ImageInferenceModel)model.getModel()).performInference(inputTensor, this.inputName, this.decode.expectedOutputs(), outputs -> this.decodeOutputs((List<T>)outputs, recorder, context));
            recorder.flush();
            return list;
        }
        catch (Throwable throwable) {
            try {
                recorder.flush();
                throw throwable;
            }
            catch (Exception e) {
                throw new ConcurrentModelException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LabelledWithConfidence<MultiScaleObject>> decodeOutputs(List<T> outputsToDecode, InferenceExecutionTimeRecorder recorder, ImageInferenceContext context) throws OperationFailedException {
        try {
            recorder.recordStartPost();
            List<LabelledWithConfidence<MultiScaleObject>> list = this.decode.decode(outputsToDecode, context);
            return list;
        }
        finally {
            recorder.recordEndPost();
        }
    }

    @Generated
    public InferenceHelper(DecodeInstanceSegmentation<T> decode, String inputName) {
        this.decode = decode;
        this.inputName = inputName;
    }
}

