/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.bean.reduce;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.core.merge.ObjectMaskMerger;
import org.anchoranalysis.image.inference.bean.reduce.ObjectForReduction;
import org.anchoranalysis.image.inference.bean.reduce.OverlapCalculator;
import org.anchoranalysis.image.inference.bean.reduce.ReduceElementsGreedy;
import org.anchoranalysis.image.inference.bean.reduce.ReduceObjectsGraph;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public class RemoveOverlappingObjects
extends ReduceElementsGreedy {
    @BeanField
    private double scoreThreshold = 0.3;

    @Override
    protected boolean shouldObjectsBeProcessed(ObjectMask source, ObjectMask other) {
        return this.overlapScoreFor(source, other) >= this.scoreThreshold;
    }

    @Override
    protected boolean processObjects(ObjectForReduction source, ObjectForReduction overlapping, ReduceObjectsGraph graph) {
        try {
            graph.removeVertex(overlapping);
        }
        catch (OperationFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
        return false;
    }

    private double overlapScoreFor(ObjectMask element1, ObjectMask element2) {
        ObjectMask merged = ObjectMaskMerger.merge((ObjectMask)element1, (ObjectMask)element2);
        return OverlapCalculator.calculateOverlapRatio(element1, element2, merged);
    }

    @Generated
    public double getScoreThreshold() {
        return this.scoreThreshold;
    }

    @Generated
    public void setScoreThreshold(double scoreThreshold) {
        this.scoreThreshold = scoreThreshold;
    }
}

