/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.bean.reduce;

import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Stream;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.graph.GraphWithoutPayload;
import org.anchoranalysis.image.inference.bean.reduce.ObjectForReduction;
import org.anchoranalysis.image.inference.bean.reduce.ObjectForReductionFactory;
import org.anchoranalysis.image.inference.segment.LabelledWithConfidence;
import org.anchoranalysis.image.voxel.object.IntersectingObjects;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public class ReduceObjectsGraph {
    private final PriorityQueue<ObjectForReduction> queue;
    private final GraphWithoutPayload<ObjectForReduction> graph;

    public ReduceObjectsGraph(List<LabelledWithConfidence<ObjectMask>> elements) {
        List<ObjectForReduction> vertices = ObjectForReductionFactory.populateFromList(elements);
        this.graph = new IntersectingObjects(vertices, ObjectForReduction::getElement).asGraph();
        this.queue = new PriorityQueue<ObjectForReduction>(vertices);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public ObjectForReduction peek() {
        return this.queue.peek();
    }

    public ObjectForReduction poll() {
        ObjectForReduction element = this.queue.poll();
        try {
            this.graph.removeVertex((Object)element);
        }
        catch (OperationFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
        return element;
    }

    public List<ObjectForReduction> adjacentVerticesOutgoing(ObjectForReduction vertex) {
        return this.graph.adjacentVerticesOutgoing((Object)vertex);
    }

    public Stream<ObjectForReduction> adjacentVerticesOutgoingStream(ObjectForReduction vertex) {
        return this.graph.adjacentVerticesOutgoingStream((Object)vertex);
    }

    public void removeEdge(ObjectForReduction from, ObjectForReduction to) {
        this.graph.removeEdge((Object)from, (Object)to);
    }

    public void removeVertex(ObjectForReduction vertex) throws OperationFailedException {
        this.queue.remove(vertex);
        this.graph.removeVertex((Object)vertex);
    }

    public void mergeVertices(ObjectForReduction element1, ObjectForReduction element2, ObjectForReduction merged) {
        this.graph.mergeVertices((Object)element1, (Object)element2, (Object)merged);
        this.queue.remove(element1);
        this.queue.remove(element2);
        this.queue.add(merged);
    }
}

