/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.segment;

import java.util.List;
import java.util.function.Function;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.bean.displayer.StackDisplayer;
import org.anchoranalysis.image.core.object.properties.ObjectCollectionWithProperties;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.inference.segment.LabelledWithConfidence;
import org.anchoranalysis.image.inference.segment.MultiScaleObject;
import org.anchoranalysis.image.inference.segment.WithConfidence;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;

public class SegmentedObjectsAtScale {
    private final List<LabelledWithConfidence<MultiScaleObject>> source;
    private final Function<MultiScaleObject, ObjectMask> extractObject;
    private final Stack background;
    private final StackDisplayer displayer;
    private final ExecutionTimeRecorder executionTimeRecorder;
    private final String executionTimeSuffix;
    private ObjectCollection objects;
    private ObjectCollectionWithProperties objectsWithProperties;
    private List<WithConfidence<ObjectMask>> listWithoutLabels;
    private List<LabelledWithConfidence<ObjectMask>> listWithLabels;
    private DisplayStack backgroundDisplayStack;

    public List<LabelledWithConfidence<ObjectMask>> listWithLabels() {
        if (this.listWithLabels == null) {
            this.listWithLabels = (List)this.executionTimeRecorder.recordExecutionTime("Segmented-objects listWith" + this.executionTimeSuffix, () -> FunctionalList.mapToList(this.source, multi -> multi.map(this.extractObject)));
        }
        return this.listWithLabels;
    }

    public List<WithConfidence<ObjectMask>> listWithoutLabels() {
        if (this.listWithoutLabels == null) {
            this.listWithoutLabels = (List)this.executionTimeRecorder.recordExecutionTime("Segmented-objects listWithout" + this.executionTimeSuffix, () -> FunctionalList.mapToList(this.source, multi -> multi.getWithConfidence().map(this.extractObject)));
        }
        return this.listWithoutLabels;
    }

    public ObjectCollection objects() {
        if (this.objects == null) {
            List<WithConfidence<ObjectMask>> withoutLabels = this.listWithoutLabels();
            this.objects = (ObjectCollection)this.executionTimeRecorder.recordExecutionTime("Segmented-objects objects" + this.executionTimeSuffix, () -> SegmentedObjectsAtScale.objectsFromList(withoutLabels));
        }
        return this.objects;
    }

    public ObjectCollectionWithProperties objectsWithProperties() {
        if (this.objectsWithProperties == null) {
            this.objectsWithProperties = new ObjectCollectionWithProperties(this.objects());
        }
        return this.objectsWithProperties;
    }

    public DisplayStack backgroundDisplayStack() {
        if (this.backgroundDisplayStack == null) {
            try {
                this.backgroundDisplayStack = this.displayer.deriveFrom(this.background);
            }
            catch (CreateException e) {
                throw new AnchorImpossibleSituationException();
            }
        }
        return this.backgroundDisplayStack;
    }

    public Extent extent() {
        return this.background.extent();
    }

    public int size() {
        return this.source.size();
    }

    private static ObjectCollection objectsFromList(List<WithConfidence<ObjectMask>> list) {
        return new ObjectCollection(list.stream().map(WithConfidence::getElement));
    }

    public SegmentedObjectsAtScale(List<LabelledWithConfidence<MultiScaleObject>> source, Function<MultiScaleObject, ObjectMask> extractObject, Stack background, StackDisplayer displayer, ExecutionTimeRecorder executionTimeRecorder, String executionTimeSuffix) {
        this.source = source;
        this.extractObject = extractObject;
        this.background = background;
        this.displayer = displayer;
        this.executionTimeRecorder = executionTimeRecorder;
        this.executionTimeSuffix = executionTimeSuffix;
    }

    public Stack background() {
        return this.background;
    }
}

