/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.segment;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.anchoranalysis.core.cache.CachedSupplier;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.inference.segment.DualScale;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public class MultiScaleObject {
    private final DualScale<CachedSupplier<ObjectMask, AnchorImpossibleSituationException>> objects;

    public MultiScaleObject(Supplier<ObjectMask> inputScale, Supplier<ObjectMask> modelScale) {
        this(new DualScale<Supplier<ObjectMask>>(inputScale, modelScale));
    }

    private MultiScaleObject(DualScale<Supplier<ObjectMask>> objects) {
        this.objects = objects.map(CachedSupplier::cache);
    }

    public static <T> MultiScaleObject extractFrom(DualScale<T> dual, Function<T, ObjectMask> extractObject) {
        return new MultiScaleObject(dual.map(element -> () -> (ObjectMask)extractObject.apply(element)));
    }

    public static <T, S> MultiScaleObject extractFrom(DualScale<T> dual1, DualScale<S> dual2, BiFunction<T, S, ObjectMask> extractObject) {
        return new MultiScaleObject(dual1.combine(dual2, (first, second) -> () -> (ObjectMask)extractObject.apply(first, second)));
    }

    public ObjectMask getInputScale() {
        return (ObjectMask)this.objects.atInputScale().get();
    }

    public ObjectMask getModelScale() {
        return (ObjectMask)this.objects.atModelScale().get();
    }
}

