/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.segment;

import java.util.List;
import org.anchoranalysis.image.core.object.scale.AccessObjectMask;
import org.anchoranalysis.image.inference.segment.WithConfidence;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class AccessSegmentedObjects
implements AccessObjectMask<WithConfidence<ObjectMask>> {
    private final List<WithConfidence<ObjectMask>> listUnscaled;

    public ObjectMask objectFor(WithConfidence<ObjectMask> element) {
        return element.getElement();
    }

    public WithConfidence<ObjectMask> shiftBy(WithConfidence<ObjectMask> element, ReadableTuple3i quantity) {
        return element.map(existingObject -> existingObject.shiftBy(quantity));
    }

    public WithConfidence<ObjectMask> clipTo(WithConfidence<ObjectMask> element, Extent extent) {
        return element.map(existingObject -> existingObject.clampTo(extent));
    }

    public WithConfidence<ObjectMask> createFrom(int index, ObjectMask object) {
        return this.listUnscaled.get(index).map(existingObject -> object);
    }

    public AccessSegmentedObjects(List<WithConfidence<ObjectMask>> listUnscaled) {
        this.listUnscaled = listUnscaled;
    }
}

