/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.bean.segment.instance;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.inference.bean.reduce.RemoveOverlappingObjects;
import org.anchoranalysis.image.inference.bean.segment.instance.SegmentStackIntoObjectsPooled;
import org.anchoranalysis.image.inference.bean.segment.reduce.ReduceElements;
import org.anchoranalysis.image.inference.segment.SegmentedObjects;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.inference.InferenceModel;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.inference.concurrency.ConcurrentModelPool;
import org.anchoranalysis.inference.concurrency.CreateModelFailedException;

public class SuppressNonMaximum<T extends InferenceModel>
extends SegmentStackIntoObjectsPooled<T> {
    @BeanField
    private SegmentStackIntoObjectsPooled<T> segment;
    @BeanField
    private ReduceElements<ObjectMask> reduce = new RemoveOverlappingObjects();
    @BeanField
    private boolean separateEachLabel = false;

    public SuppressNonMaximum(SegmentStackIntoObjectsPooled<T> segment) {
        this.segment = segment;
    }

    @Override
    public ConcurrentModelPool<T> createModelPool(ConcurrencyPlan plan, Logger logger) throws CreateModelFailedException {
        return this.segment.createModelPool(plan, logger);
    }

    @Override
    public SegmentedObjects segment(Stack stack, ConcurrentModelPool<T> modelPool, ExecutionTimeRecorder executionTimeRecorder) throws SegmentationFailedException {
        SegmentedObjects objects = this.segment.segment(stack, modelPool, executionTimeRecorder);
        try {
            return (SegmentedObjects)executionTimeRecorder.recordExecutionTime("Non-maximum suppression", () -> objects.reduce(this.reduce, this.separateEachLabel, executionTimeRecorder));
        }
        catch (OperationFailedException e) {
            throw new SegmentationFailedException((Throwable)e);
        }
    }

    public SuppressNonMaximum() {
    }

    public SuppressNonMaximum(SegmentStackIntoObjectsPooled<T> segment, ReduceElements<ObjectMask> reduce, boolean separateEachLabel) {
        this.segment = segment;
        this.reduce = reduce;
        this.separateEachLabel = separateEachLabel;
    }

    public SegmentStackIntoObjectsPooled<T> getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentStackIntoObjectsPooled<T> segment) {
        this.segment = segment;
    }

    public ReduceElements<ObjectMask> getReduce() {
        return this.reduce;
    }

    public void setReduce(ReduceElements<ObjectMask> reduce) {
        this.reduce = reduce;
    }

    public boolean isSeparateEachLabel() {
        return this.separateEachLabel;
    }

    public void setSeparateEachLabel(boolean separateEachLabel) {
        this.separateEachLabel = separateEachLabel;
    }
}

