/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.bean.segment.instance;

import java.util.Optional;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;

class InferenceExecutionTimeRecorder {
    private static final String IDENTIFIER_POST = "Post-processing inference";
    private final ExecutionTimeRecorder recorder;
    private final Optional<String> identifierInferenceWarmUp;
    private final String identifierInferenceSubsequent;
    private long timestampStartInference;
    private long timestampStartPostProcessing;
    private long timestampEndPostProcessing;

    public InferenceExecutionTimeRecorder(ExecutionTimeRecorder recorder, boolean gpu) {
        this.recorder = recorder;
        this.identifierInferenceWarmUp = OptionalFactory.create((boolean)gpu, (Object)"Model inference (GPU with Warm Up)");
        this.identifierInferenceSubsequent = InferenceExecutionTimeRecorder.identifierSubsequent(gpu);
    }

    public void recordStartInference() {
        this.timestampStartInference = this.recorder.measureTime(true, this.allPossibleInferenceIdentifiers());
    }

    public void recordStartPost() {
        this.timestampStartPostProcessing = this.recorder.measureTime(true, new String[]{IDENTIFIER_POST});
    }

    public void recordEndPost() {
        this.timestampEndPostProcessing = this.recorder.measureTime(false, new String[]{IDENTIFIER_POST});
    }

    public void flush() {
        this.recorder.recordTimeDifferenceBetween(this.inferenceIdentifier(), this.timestampStartInference, this.timestampStartPostProcessing);
        this.recorder.recordTimeDifferenceBetween(IDENTIFIER_POST, this.timestampStartPostProcessing, this.timestampEndPostProcessing);
    }

    private String inferenceIdentifier() {
        if (this.identifierInferenceWarmUp.isPresent() && !this.recorder.isOperationAlreadyRecorded(this.identifierInferenceWarmUp.get())) {
            return this.identifierInferenceWarmUp.get();
        }
        return this.identifierInferenceSubsequent;
    }

    private String[] allPossibleInferenceIdentifiers() {
        if (this.identifierInferenceWarmUp.isPresent()) {
            return new String[]{this.identifierInferenceWarmUp.get(), InferenceExecutionTimeRecorder.identifierSubsequent(true), InferenceExecutionTimeRecorder.identifierSubsequent(false)};
        }
        return new String[]{InferenceExecutionTimeRecorder.identifierSubsequent(false)};
    }

    private static String identifierSubsequent(boolean gpu) {
        return InferenceExecutionTimeRecorder.addSuffix("Model inference", gpu);
    }

    private static String addSuffix(String string, boolean gpu) {
        return String.format("%s (%s)", string, gpu ? "GPU" : "CPU");
    }
}

