/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.fill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.ToDoubleFunction;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;

class LinearPartition {
    public static List<List<Integer>> partition(List<Integer> list, int numberPartitions) throws OperationFailedException {
        return LinearPartition.partition(list, value -> value.intValue(), numberPartitions);
    }

    public static <T> List<List<T>> partition(List<T> list, ToDoubleFunction<T> extractCost, int numberPartitions) throws OperationFailedException {
        LinearPartition.checkSizes(list.size(), numberPartitions);
        if (list.size() == numberPartitions) {
            return Arrays.asList(new ArrayList<T>(list));
        }
        int[][] table = LinearPartition.buildPartitionTable(list, extractCost, numberPartitions);
        return LinearPartition.derivePartitionsFromTable(table, list, numberPartitions - 2);
    }

    private static void checkSizes(int numberElements, int numberPartitions) throws OperationFailedException {
        if (numberPartitions <= 0) {
            throw new OperationFailedException(String.format("The number of partitions of %d is invalid.", numberPartitions));
        }
        if (numberElements < numberPartitions) {
            throw new OperationFailedException(String.format("There are %d elements in the list, which is too few to split into %d partitions", numberElements, numberPartitions));
        }
    }

    private static <T> int[][] buildPartitionTable(List<T> elements, ToDoubleFunction<T> extractCost, int numberPartitions) {
        int i;
        double[][] costs = new double[elements.size()][numberPartitions];
        int[][] solution = new int[elements.size() - 1][numberPartitions - 1];
        for (i = 0; i < elements.size(); ++i) {
            costs[i][0] = extractCost.applyAsDouble(elements.get(i)) + (i > 0 ? costs[i - 1][0] : 0.0);
        }
        for (int j = 0; j < numberPartitions; ++j) {
            costs[0][j] = extractCost.applyAsDouble(elements.get(0));
        }
        for (i = 1; i < elements.size(); ++i) {
            for (int j = 1; j < numberPartitions; ++j) {
                costs[i][j] = 2.147483647E9;
                for (int x = 0; x < i; ++x) {
                    double positionCost = Math.max(costs[x][j - 1], costs[i][0] - costs[x][0]);
                    if (!(costs[i][j] > positionCost)) continue;
                    costs[i][j] = positionCost;
                    solution[i - 1][j - 1] = x;
                }
            }
        }
        return solution;
    }

    private static <T> LinkedList<List<T>> derivePartitionsFromTable(int[][] table, List<T> list, int partitionIndex) {
        LinkedList<List<T>> partitions = new LinkedList<List<T>>();
        int elementIndex = list.size() - 1;
        while (partitionIndex >= 0) {
            LinearPartition.addPartition(list, table[elementIndex - 1][partitionIndex] + 1, elementIndex + 1, partitions);
            elementIndex = table[elementIndex - 1][partitionIndex];
            --partitionIndex;
        }
        LinearPartition.addPartition(list, 0, elementIndex + 1, partitions);
        return partitions;
    }

    private static <T> void addPartition(List<T> elements, int startIndexInclusive, int endIndexExclusive, LinkedList<List<T>> partitions) {
        ArrayList<T> partition = new ArrayList<T>(elements.subList(startIndexInclusive, endIndexExclusive));
        partitions.addFirst(partition);
    }

    @Generated
    private LinearPartition() {
    }
}

