/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.fill;

import java.util.Collection;
import java.util.List;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import lombok.Generated;
import org.anchoranalysis.image.bean.spatial.arrange.fill.ExtentToArrange;
import org.anchoranalysis.image.bean.spatial.arrange.fill.ScaleElementsInRow;
import org.anchoranalysis.spatial.box.Extent;

public class FitCombinedScaler {
    private static final double MAXIMUM_PERMITTED_DIFFERENCE_ASPECT_RATIO_FINAL_ROW = 1.2;

    public static Extent scaleToWidth(List<List<ExtentToArrange>> partitions, boolean permitPartialFinalRow, int width) {
        FitCombinedScaler.scaleImagesToMatchRow(partitions, width, permitPartialFinalRow);
        int height = FitCombinedScaler.sumExtractedInt(partitions, row -> ((ExtentToArrange)row.get(0)).getExtent().y());
        return new Extent(width, height, 1);
    }

    private static void scaleImagesToMatchRow(List<List<ExtentToArrange>> partitions, int rowWidth, boolean permitPartialFinalRow) {
        double sumOfSums = 0.0;
        int lastIndex = partitions.size() - 1;
        for (int index = 0; index < partitions.size(); ++index) {
            List<ExtentToArrange> row = partitions.get(index);
            double aspectRatioSum = FitCombinedScaler.sumExtractedDouble(row, ExtentToArrange::getAspectRatio);
            if (permitPartialFinalRow && index == lastIndex && partitions.size() > 1) {
                rowWidth = FitCombinedScaler.maybeAdjustTargetRowWidth(aspectRatioSum, sumOfSums / (double)index, rowWidth);
            }
            sumOfSums += aspectRatioSum;
            ScaleElementsInRow.scaleElementsToMatchRow(row, rowWidth, aspectRatioSum);
        }
    }

    private static int maybeAdjustTargetRowWidth(double currentHeight, double meanHeight, int rowWidth) {
        if (currentHeight < 1.2 * meanHeight) {
            return (int)((double)rowWidth * (currentHeight / meanHeight));
        }
        return rowWidth;
    }

    private static <T> int sumExtractedInt(Collection<T> collection, ToIntFunction<T> extractValue) {
        return collection.stream().mapToInt(extractValue::applyAsInt).sum();
    }

    private static <T> double sumExtractedDouble(Collection<T> collection, ToDoubleFunction<T> extractValue) {
        return collection.stream().mapToDouble(extractValue::applyAsDouble).sum();
    }

    @Generated
    private FitCombinedScaler() {
    }
}

