/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.nonbean.spatial.arrange;

import lombok.Generated;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.BufferPair;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class StackCopierAtBox {
    public static void copyImageInto(Stack source, Stack destination, BoundingBox box) {
        if (box.extent().z() != source.dimensions().z()) {
            if (source.dimensions().z() == 1) {
                StackCopierAtBox.copyImageRepeatedZ(source, destination, box);
            } else if (box.extent().z() == 1) {
                StackCopierAtBox.copyImage(source.projectMax(), destination, box, 0);
            } else {
                StackCopierAtBox.copyImageRepeatedZ(source.projectMax(), destination, box);
            }
        } else {
            StackCopierAtBox.copyImage(source, destination, box, 0);
        }
    }

    private static void copyImageRepeatedZ(Stack source, Stack destination, BoundingBox box) {
        int zShift = 0;
        do {
            StackCopierAtBox.copyImage(source, destination, box, zShift);
        } while ((zShift += source.dimensions().z()) < destination.dimensions().z());
    }

    private static void copyImage(Stack source, Stack destination, BoundingBox box, int zShift) {
        Extent extent = source.extent();
        ReadableTuple3i cornerMin = box.cornerMin();
        ReadableTuple3i cornerMax = box.calculateCornerMaxInclusive();
        BufferPair buffers = new BufferPair(destination.getNumberChannels());
        for (int z = 0; z < extent.z(); ++z) {
            buffers.assign(source, destination, z, z + cornerMin.z() + zShift);
            buffers.copySlice(cornerMin, cornerMax, destination.extent());
        }
    }

    @Generated
    private StackCopierAtBox() {
    }
}

