/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.nonbean;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

public class ConsistentChannelChecker {
    private VoxelDataType voxelDataType;

    public void checkChannelType(Channel channel) throws OperationFailedException {
        if (this.voxelDataType == null) {
            this.voxelDataType = channel.getVoxelDataType();
        } else if (!channel.getVoxelDataType().equals((Object)this.voxelDataType)) {
            throw new OperationFailedException(String.format("All images must have identical voxel-data-types, but they are not consistent: %s versus %s", this.voxelDataType, channel.getVoxelDataType()));
        }
    }

    public VoxelDataType getVoxelDataType() {
        if (this.voxelDataType != null) {
            return this.voxelDataType;
        }
        throw new AnchorFriendlyRuntimeException("There have been no calls to checkChannelType, so no consistent voxelDataType has been established");
    }
}

