/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.unitvalue.extent.volume;

import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.image.bean.nonbean.UnitValueException;
import org.anchoranalysis.image.bean.unitvalue.extent.volume.UnitValueVolume;
import org.anchoranalysis.image.core.dimensions.UnitConverter;

public class VolumePhysical
extends UnitValueVolume {
    @BeanField
    private double value;
    @BeanField
    private String unitType = "";

    @Override
    public double resolveToVoxels(Optional<UnitConverter> unitConverter) throws UnitValueException {
        if (!unitConverter.isPresent()) {
            throw new UnitValueException("A unit-converter is required to calculate physical-volume but it is missing. Is the image resolution known?");
        }
        return unitConverter.get().fromPhysicalVolume(this.value, this.unitType);
    }

    public String toString() {
        if (this.unitType != null && !this.unitType.isEmpty()) {
            return String.format("%.2f%s", this.value, this.unitType);
        }
        return String.format("%.2f", this.value);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public void setUnitType(String unitType) {
        this.unitType = unitType;
    }
}

