/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.unitvalue.extent.area;

import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.image.bean.nonbean.UnitValueException;
import org.anchoranalysis.image.bean.unitvalue.extent.area.UnitValueArea;
import org.anchoranalysis.image.core.dimensions.UnitConverter;

public class AreaPhysical
extends UnitValueArea {
    @BeanField
    private double value;
    @BeanField
    private String unitType = "";

    @Override
    public double resolveToVoxels(Optional<UnitConverter> unitConverter) throws UnitValueException {
        if (!unitConverter.isPresent()) {
            throw new UnitValueException("An image resolution is required to calculate physical-area but it is missing");
        }
        return unitConverter.get().fromPhysicalArea(this.getValue(), this.unitType);
    }

    public String toString() {
        if (this.unitType != null && !this.unitType.isEmpty()) {
            return String.format("%.2f%s", this.value, this.unitType);
        }
        return String.format("%.2f", this.value);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public void setUnitType(String unitType) {
        this.unitType = unitType;
    }
}

