/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.tile;

import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.StackArrangement;
import org.anchoranalysis.image.bean.spatial.arrange.tile.ArrangementIndex;
import org.anchoranalysis.image.bean.spatial.arrange.tile.SizeAtPoint;
import org.anchoranalysis.image.bean.spatial.arrange.tile.SizesAcrossDimension;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class CellSizeCalculator {
    private SizesAcrossDimension rowHeights;
    private SizesAcrossDimension columnWidths;
    private int maxZ = 0;

    public CellSizeCalculator(ArrangementIndex table) {
        this.rowHeights = this.processDimension(table.getNumberRows(), table::getRow, Extent::y);
        this.columnWidths = this.processDimension(table.getNumberColumns(), table::getColumn, Extent::x);
    }

    public BoundingBox cell(int columnIndex, int rowIndex) {
        SizeAtPoint width = this.columnWidths.get(columnIndex);
        SizeAtPoint height = this.rowHeights.get(rowIndex);
        Point3i cornerPoint = new Point3i(width.getPoint(), height.getPoint(), 0);
        Extent cellSize = new Extent(width.getSize(), height.getSize(), this.maxZ);
        return BoundingBox.createReuse((ReadableTuple3i)cornerPoint, (Extent)cellSize);
    }

    public Extent total() {
        if (this.columnWidths.getSum() != 0 && this.rowHeights.getSum() != 0 && this.maxZ != 0) {
            return new Extent(this.columnWidths.getSum(), this.rowHeights.getSum(), this.maxZ);
        }
        throw new AnchorFriendlyRuntimeException(String.format("At least one dimension is zero: %d, %d, %d", this.columnWidths.getSum(), this.rowHeights.getSum(), this.maxZ));
    }

    private SizesAcrossDimension processDimension(int numberElements, IntFunction<Stream<StackArrangement>> elementsForIndex, ToIntFunction<Extent> extractSize) {
        SizesAcrossDimension sizes = new SizesAcrossDimension(numberElements);
        for (int i = 0; i < numberElements; ++i) {
            Stream<StackArrangement> elements = elementsForIndex.apply(i);
            sizes.add(this.maxSizeForDimension(elements, extractSize));
        }
        return sizes;
    }

    private int maxSizeForDimension(Stream<StackArrangement> cells, ToIntFunction<Extent> extractDimension) {
        return cells.map(StackArrangement::extent).mapToInt(extent -> this.extractDimensionAndUpdateZ((Extent)extent, extractDimension)).max().getAsInt();
    }

    private int extractDimensionAndUpdateZ(Extent extent, ToIntFunction<Extent> extractDimension) {
        if (extent.z() > this.maxZ) {
            this.maxZ = extent.z();
        }
        return extractDimension.applyAsInt(extent);
    }
}

