/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.fill;

import org.anchoranalysis.spatial.box.Extent;

public class ExtentToArrange
implements Comparable<ExtentToArrange> {
    private final int index;
    private Extent extent;
    private final double aspectRatio;
    private double scaleRoundingError = 0.0;

    public ExtentToArrange(int index, Extent extent) {
        this.index = index;
        this.extent = extent;
        this.aspectRatio = extent.aspectRatioXY();
    }

    public int scaleToMatchRow(double sumAspectRatios, int rowWidth) {
        double scaleFactor = this.extractScaleFactor(sumAspectRatios, rowWidth);
        Extent extentToAssign = this.extent.scaleXYBy(scaleFactor, true);
        this.scaleRoundingError = scaleFactor * (double)this.extent.x() - (double)extentToAssign.x();
        this.extent = extentToAssign;
        return this.extent.x();
    }

    public void growWidth(int growBy) {
        this.extent = this.extent.duplicateChangeX(this.extent.x() + growBy);
    }

    public int width() {
        return this.extent.x();
    }

    public double aspectRatioInverted() {
        return 1.0 / this.aspectRatio;
    }

    @Override
    public int compareTo(ExtentToArrange other) {
        return -1 * this.extent.compareTo(other.extent);
    }

    public boolean equals(Object other) {
        if (other instanceof ExtentToArrange) {
            ExtentToArrange otherCast = (ExtentToArrange)other;
            return this.extent.equals((Object)otherCast.extent);
        }
        return false;
    }

    public int hashCode() {
        return this.extent.hashCode();
    }

    private double extractScaleFactor(double sumAspectRatios, int rowWidth) {
        double widthPercent = this.aspectRatio / sumAspectRatios;
        return widthPercent * (double)rowWidth / (double)this.extent.x();
    }

    public String toString() {
        return "ExtentToArrange(index=" + this.getIndex() + ", extent=" + this.getExtent() + ", aspectRatio=" + this.getAspectRatio() + ", scaleRoundingError=" + this.getScaleRoundingError() + ")";
    }

    public int getIndex() {
        return this.index;
    }

    public Extent getExtent() {
        return this.extent;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public double getScaleRoundingError() {
        return this.scaleRoundingError;
    }
}

